/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.IncludeFileEdge;
import org.gradle.language.nativeplatform.internal.incremental.SourceFileState;

public class CompilationStateSerializer
implements Serializer<CompilationState> {
    private final Serializer<File> fileSerializer;
    private final Serializer<HashCode> hashSerializer = new HashCodeSerializer();

    public CompilationStateSerializer() {
        this.fileSerializer = new BaseSerializerFactory().getSerializerFor(File.class);
    }

    public CompilationState read(Decoder decoder) throws Exception {
        HashMap<Integer, IncludeFileEdge> ids = new HashMap<Integer, IncludeFileEdge>();
        int sourceFileCount = decoder.readSmallInt();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < sourceFileCount; ++i) {
            File sourceFile = (File)this.fileSerializer.read(decoder);
            HashCode sourceHashCode = (HashCode)this.hashSerializer.read(decoder);
            boolean isUnresolved = decoder.readBoolean();
            int includeFileCount = decoder.readSmallInt();
            ImmutableSet.Builder includeFileStateBuilder = ImmutableSet.builder();
            for (int j = 0; j < includeFileCount; ++j) {
                int id = decoder.readSmallInt();
                IncludeFileEdge includeFileState = (IncludeFileEdge)ids.get(id);
                if (includeFileState == null) {
                    String includePath = decoder.readString();
                    HashCode includedBy = null;
                    if (decoder.readBoolean()) {
                        includedBy = (HashCode)this.hashSerializer.read(decoder);
                    }
                    HashCode resolvedTo = (HashCode)this.hashSerializer.read(decoder);
                    includeFileState = new IncludeFileEdge(includePath, includedBy, resolvedTo);
                    ids.put(id, includeFileState);
                }
                includeFileStateBuilder.add((Object)includeFileState);
            }
            builder.put((Object)sourceFile, (Object)new SourceFileState(sourceHashCode, isUnresolved, (ImmutableSet<IncludeFileEdge>)includeFileStateBuilder.build()));
        }
        return new CompilationState((ImmutableMap<File, SourceFileState>)builder.build());
    }

    public void write(Encoder encoder, CompilationState value) throws Exception {
        HashMap<IncludeFileEdge, Integer> ids = new HashMap<IncludeFileEdge, Integer>();
        encoder.writeSmallInt(value.getFileStates().size());
        for (Map.Entry entry : value.getFileStates().entrySet()) {
            SourceFileState sourceFileState = (SourceFileState)entry.getValue();
            this.fileSerializer.write(encoder, entry.getKey());
            this.hashSerializer.write(encoder, (Object)sourceFileState.getHash());
            encoder.writeBoolean(sourceFileState.isHasUnresolved());
            encoder.writeSmallInt(sourceFileState.getEdges().size());
            for (IncludeFileEdge includeFileState : sourceFileState.getEdges()) {
                Integer id = (Integer)ids.get(includeFileState);
                if (id == null) {
                    id = ids.size();
                    ids.put(includeFileState, id);
                    encoder.writeSmallInt(id.intValue());
                    encoder.writeString((CharSequence)includeFileState.getIncludePath());
                    if (includeFileState.getIncludedBy() == null) {
                        encoder.writeBoolean(false);
                    } else {
                        encoder.writeBoolean(true);
                        this.hashSerializer.write(encoder, (Object)includeFileState.getIncludedBy());
                    }
                    this.hashSerializer.write(encoder, (Object)includeFileState.getResolvedTo());
                    continue;
                }
                encoder.writeSmallInt(id.intValue());
            }
        }
    }
}

