/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.model.ModelSet;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSetSchema;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

public class ModelSetStrategy
implements ModelSchemaExtractionStrategy {
    private final ModelType<?> modelType = new ModelType<ModelSet<?>>(){};

    @Override
    public <T> void extract(ModelSchemaExtractionContext<T> extractionContext) {
        ModelType<T> type = extractionContext.getType();
        if (this.modelType.isAssignableFrom(type)) {
            if (!type.getRawClass().equals(ModelSet.class)) {
                extractionContext.add(String.format("subtyping %s is not supported", ModelSet.class.getName()));
                return;
            }
            if (type.isHasWildcardTypeVariables()) {
                extractionContext.add(String.format("type parameter of %s cannot be a wildcard", ModelSet.class.getName()));
                return;
            }
            List<ModelType<?>> typeVariables = type.getTypeVariables();
            if (typeVariables.isEmpty()) {
                extractionContext.add(String.format("type parameter of %s has to be specified", ModelSet.class.getName()));
                return;
            }
            ModelType<?> elementType = typeVariables.get(0);
            extractionContext.found(this.getModelSchema(extractionContext, elementType));
        }
    }

    private <T, E> ModelSchema<T> getModelSchema(ModelSchemaExtractionContext<T> extractionContext, ModelType<E> elementType) {
        final ModelSetSchema<T, E> schema = new ModelSetSchema<T, E>(extractionContext.getType(), elementType);
        extractionContext.child(elementType, "element type", new Action<ModelSchema<E>>(){

            public void execute(ModelSchema<E> elementTypeSchema) {
                schema.setElementTypeSchema(elementTypeSchema);
            }
        });
        return schema;
    }
}

