/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import megamek.client.Client;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.IBoardView;
import megamek.client.ui.Messages;
import megamek.common.Coords;
import megamek.common.LosEffects;
import megamek.common.ToHitData;

public class Ruler
extends Dialog
implements BoardViewListener {
    private static final long serialVersionUID = 704013239167655138L;
    public static Color color1 = Color.cyan;
    public static Color color2 = Color.magenta;
    private Coords start;
    private Coords end;
    private Color startColor;
    private Color endColor;
    private int distance;
    private Client client;
    private IBoardView bv;
    private boolean flip;
    Panel panel1 = new Panel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    Button butFlip = new Button();
    Label jLabel1 = new Label();
    TextField tf_start = new TextField();
    Label jLabel2 = new Label();
    TextField tf_end = new TextField();
    Label jLabel3 = new Label();
    TextField tf_distance = new TextField();
    Label jLabel4 = new Label();
    TextField tf_los1 = new TextField();
    Label jLabel5 = new Label();
    TextField tf_los2 = new TextField();
    Button butClose = new Button();
    Label heightLabel1 = new Label();
    TextField height1 = new TextField();
    Label heightLabel2 = new Label();
    TextField height2 = new TextField();

    public Ruler(Frame frame, Client client, IBoardView iBoardView) {
        super(frame, Messages.getString("Ruler.title"), false);
        this.enableEvents(64L);
        this.start = null;
        this.end = null;
        this.flip = true;
        this.startColor = color1;
        this.endColor = color2;
        this.bv = iBoardView;
        this.client = client;
        iBoardView.addBoardViewListener(this);
        try {
            this.jbInit();
            this.add(this.panel1);
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.butFlip.setLabel(Messages.getString("Ruler.flip"));
        this.butFlip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Ruler.this.butFlip_actionPerformed(actionEvent);
            }
        });
        this.panel1.setLayout(this.gridBagLayout1);
        this.jLabel1.setText(Messages.getString("Ruler.Start"));
        this.tf_start.setEditable(false);
        this.tf_start.setColumns(16);
        this.jLabel2.setText(Messages.getString("Ruler.End"));
        this.tf_end.setEditable(false);
        this.tf_end.setColumns(16);
        this.jLabel3.setText(Messages.getString("Ruler.Distance"));
        this.tf_distance.setEditable(false);
        this.tf_distance.setColumns(5);
        this.jLabel4.setText(Messages.getString("Ruler.POV") + ": ");
        this.jLabel4.setForeground(this.startColor);
        this.tf_los1.setEditable(false);
        this.tf_los1.setColumns(30);
        this.jLabel5.setText(Messages.getString("Ruler.POV"));
        this.jLabel5.setForeground(this.endColor);
        this.tf_los2.setEditable(false);
        this.tf_los2.setColumns(30);
        this.butClose.setLabel(Messages.getString("Ruler.Close"));
        this.butClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Ruler.this.butClose_actionPerformed(actionEvent);
            }
        });
        this.heightLabel1.setText(Messages.getString("Ruler.Height1"));
        this.heightLabel1.setForeground(this.startColor);
        this.height1.setText("1");
        this.height1.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                Ruler.this.height1_keyReleased(keyEvent);
            }
        });
        this.height1.setColumns(5);
        this.heightLabel2.setText(Messages.getString("Ruler.Height2"));
        this.heightLabel2.setForeground(this.endColor);
        this.height2.setText("1");
        this.height2.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                Ruler.this.height2_keyReleased(keyEvent);
            }
        });
        this.height2.setColumns(5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.gridBagLayout1.setConstraints(this.butFlip, gridBagConstraints);
        this.panel1.add(this.butFlip);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        this.gridBagLayout1.setConstraints(this.heightLabel1, gridBagConstraints);
        this.panel1.add(this.heightLabel1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        this.gridBagLayout1.setConstraints(this.height1, gridBagConstraints);
        this.panel1.add(this.height1);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        this.gridBagLayout1.setConstraints(this.heightLabel2, gridBagConstraints);
        this.panel1.add(this.heightLabel2);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        this.gridBagLayout1.setConstraints(this.height2, gridBagConstraints);
        this.panel1.add(this.height2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        this.gridBagLayout1.setConstraints(this.jLabel1, gridBagConstraints);
        this.panel1.add(this.jLabel1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        this.gridBagLayout1.setConstraints(this.tf_start, gridBagConstraints);
        this.panel1.add(this.tf_start);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        this.gridBagLayout1.setConstraints(this.jLabel2, gridBagConstraints);
        this.panel1.add(this.jLabel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        this.gridBagLayout1.setConstraints(this.tf_end, gridBagConstraints);
        this.panel1.add(this.tf_end);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        this.gridBagLayout1.setConstraints(this.jLabel3, gridBagConstraints);
        this.panel1.add(this.jLabel3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        this.gridBagLayout1.setConstraints(this.tf_distance, gridBagConstraints);
        this.panel1.add(this.tf_distance);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        this.gridBagLayout1.setConstraints(this.jLabel4, gridBagConstraints);
        this.panel1.add(this.jLabel4);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        this.gridBagLayout1.setConstraints(this.tf_los1, gridBagConstraints);
        this.panel1.add(this.tf_los1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        this.gridBagLayout1.setConstraints(this.jLabel5, gridBagConstraints);
        this.panel1.add(this.jLabel5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        this.gridBagLayout1.setConstraints(this.tf_los2, gridBagConstraints);
        this.panel1.add(this.tf_los2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        this.gridBagLayout1.setConstraints(this.butClose, gridBagConstraints);
        this.panel1.add(this.butClose);
        this.validate();
        this.setVisible(false);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(windowEvent);
    }

    void cancel() {
        this.dispose();
        this.butClose_actionPerformed(null);
    }

    public Coords getStart() {
        return this.start;
    }

    public void setStart(Coords coords) {
        this.start = coords;
    }

    public void setEnd(Coords coords) {
        this.end = coords;
    }

    public Coords getEnd() {
        return this.end;
    }

    public void clear() {
        this.start = null;
        this.end = null;
    }

    public void addPoint(Coords coords) {
        if (this.start == null) {
            this.start = coords;
        } else if (this.start.equals(coords)) {
            this.clear();
            this.setVisible(false);
        } else {
            this.end = coords;
            this.distance = this.start.distance(this.end);
            this.setText();
            this.setVisible(true);
        }
    }

    public void setText() {
        int n = 1;
        int n2 = 1;
        try {
            n = Integer.parseInt(this.height1.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n2 = Integer.parseInt(this.height2.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string = "";
        String string2 = "";
        ToHitData toHitData = this.flip ? LosEffects.calculateLos(this.client.game, this.buildAttackInfo(this.start, this.end, n, n2)).losModifiers(this.client.game) : LosEffects.calculateLos(this.client.game, this.buildAttackInfo(this.end, this.start, n2, n)).losModifiers(this.client.game);
        if (toHitData.getValue() != Integer.MAX_VALUE) {
            string = toHitData.getValue() + " = ";
        }
        string = string + toHitData.getDesc();
        toHitData = this.flip ? LosEffects.calculateLos(this.client.game, this.buildAttackInfo(this.end, this.start, n2, n)).losModifiers(this.client.game) : LosEffects.calculateLos(this.client.game, this.buildAttackInfo(this.start, this.end, n, n2)).losModifiers(this.client.game);
        if (toHitData.getValue() != Integer.MAX_VALUE) {
            string2 = toHitData.getValue() + " = ";
        }
        string2 = string2 + toHitData.getDesc();
        this.tf_start.setText(this.start.toString());
        this.tf_end.setText(this.end.toString());
        this.tf_distance.setText("" + this.distance);
        this.tf_los1.setText(string);
        this.tf_los2.setText(string2);
    }

    LosEffects.AttackInfo buildAttackInfo(Coords coords, Coords coords2, int n, int n2) {
        LosEffects.AttackInfo attackInfo = new LosEffects.AttackInfo();
        attackInfo.attackPos = coords;
        attackInfo.targetPos = coords2;
        attackInfo.attackHeight = n;
        attackInfo.targetHeight = n2;
        attackInfo.attackAbsHeight = this.client.game.getBoard().getHex(coords).floor() + n;
        attackInfo.targetAbsHeight = this.client.game.getBoard().getHex(coords2).floor() + n2;
        return attackInfo;
    }

    public boolean valid() {
        return this.start != null && this.end != null;
    }

    public void setDistance(int n) {
        this.distance = n;
    }

    public int getDistance() {
        return this.distance;
    }

    public void hexMoused(BoardViewEvent boardViewEvent) {
        if ((boardViewEvent.getModifiers() & 8) != 0 && boardViewEvent.getType() == 0) {
            this.addPoint(boardViewEvent.getCoords());
        }
        this.bv.drawRuler(this.start, this.end, this.startColor, this.endColor);
    }

    public void hexCursor(BoardViewEvent boardViewEvent) {
    }

    public void boardHexHighlighted(BoardViewEvent boardViewEvent) {
    }

    public void hexSelected(BoardViewEvent boardViewEvent) {
    }

    public void firstLOSHex(BoardViewEvent boardViewEvent) {
    }

    public void secondLOSHex(BoardViewEvent boardViewEvent, Coords coords) {
    }

    void butFlip_actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.flip = !this.flip;
        if (this.startColor == color1) {
            this.startColor = color2;
            this.endColor = color1;
        } else {
            this.startColor = color1;
            this.endColor = color2;
        }
        this.heightLabel1.setForeground(this.startColor);
        this.heightLabel2.setForeground(this.endColor);
        this.setText();
        this.setVisible(true);
        this.bv.drawRuler(this.start, this.end, this.startColor, this.endColor);
    }

    void butClose_actionPerformed(ActionEvent actionEvent) {
        this.clear();
        this.setVisible(false);
        this.bv.drawRuler(this.start, this.end, this.startColor, this.endColor);
    }

    void height1_keyReleased(KeyEvent keyEvent) {
        this.setText();
        this.setVisible(true);
    }

    void height2_keyReleased(KeyEvent keyEvent) {
        this.setText();
        this.setVisible(true);
    }

    public void boardChangedEntity(BoardViewEvent boardViewEvent) {
    }

    public void boardNewAttack(BoardViewEvent boardViewEvent) {
    }

    public void finishedMovingUnits(BoardViewEvent boardViewEvent) {
    }

    public void unitSelected(BoardViewEvent boardViewEvent) {
    }
}

