/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import megamek.common.ASFBay;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.Bay;
import megamek.common.Compute;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HeavyVehicleBay;
import megamek.common.HitData;
import megamek.common.LightVehicleBay;
import megamek.common.MechBay;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.SmallCraftBay;
import megamek.common.SpaceStation;
import megamek.common.Warship;
import megamek.common.WeaponType;
import megamek.common.weapons.BayWeapon;

public class Jumpship
extends Aero
implements Serializable {
    private static final long serialVersionUID = 9154398176617208384L;
    public static final int LOC_NOSE = 0;
    public static final int LOC_FLS = 1;
    public static final int LOC_FRS = 2;
    public static final int LOC_AFT = 3;
    public static final int LOC_ALS = 4;
    public static final int LOC_ARS = 5;
    protected static String[] LOCATION_ABBRS = new String[]{"NOS", "FLS", "FRS", "AFT", "ALS", "ARS"};
    protected static String[] LOCATION_NAMES = new String[]{"Nose", "Left Front Side", "Right Front Side", "Aft", "Aft Left Side", "Aft Right Side"};
    private int kf_integrity = 0;
    private int sail_integrity = 0;
    private int[] damThresh = new int[]{0, 0, 0, 0, 0, 0};
    private int[] standard_damage = new int[]{0, 0, 0, 0, 0, 0};
    private int nCrew = 0;
    private int nPassenger = 0;
    private int lifeBoats = 0;
    private int escapePods = 0;
    boolean hasLF = false;
    private boolean hasHPG = false;
    private int gravDeck = 0;
    private int gravDeckLarge = 0;
    private int gravDeckHuge = 0;
    private double stationThrust = 0.2;
    private double accumulatedThrust = 0.0;

    public int locations() {
        return 6;
    }

    public int getTotalGravDeck() {
        return this.gravDeck + this.gravDeckLarge + this.gravDeckHuge;
    }

    public void setGravDeck(int n) {
        this.gravDeck = n;
    }

    public int getGravDeck() {
        return this.gravDeck;
    }

    public void setGravDeckLarge(int n) {
        this.gravDeckLarge = n;
    }

    public int getGravDeckLarge() {
        return this.gravDeckLarge;
    }

    public void setGravDeckHuge(int n) {
        this.gravDeckHuge = n;
    }

    public int getGravDeckHuge() {
        return this.gravDeckHuge;
    }

    public void setHPG(boolean bl) {
        this.hasHPG = bl;
    }

    public boolean hasHPG() {
        return this.hasHPG;
    }

    public void setLF(boolean bl) {
        this.hasLF = bl;
    }

    public boolean hasLF() {
        return this.hasLF;
    }

    public void setEscapePods(int n) {
        this.escapePods = n;
    }

    public int getEscapePods() {
        return this.escapePods;
    }

    public void setLifeBoats(int n) {
        this.lifeBoats = n;
    }

    public int getLifeBoats() {
        return this.lifeBoats;
    }

    public void setNCrew(int n) {
        this.nCrew = n;
    }

    public void setNPassenger(int n) {
        this.nPassenger = n;
    }

    public int getNCrew() {
        return this.nCrew;
    }

    public int getNPassenger() {
        return this.nPassenger;
    }

    public void setThresh(int n, int n2) {
        this.damThresh[n2] = n;
    }

    public int getThresh(int n) {
        return this.damThresh[n];
    }

    public void autoSetThresh() {
        for (int i = 0; i < this.locations(); ++i) {
            this.initializeThresh(i);
        }
    }

    public void initializeThresh(int n) {
        int n2 = (int)Math.ceil((double)this.getArmor(n) / 10.0);
        this.setThresh(n2, n);
    }

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public void setKFIntegrity(int n) {
        this.kf_integrity = n;
    }

    public int getKFIntegrity() {
        return this.kf_integrity;
    }

    public void setSailIntegrity(int n) {
        this.sail_integrity = n;
    }

    public int getSailIntegrity() {
        return this.sail_integrity;
    }

    public void initializeSailIntegrity() {
        int n = 1 + (int)Math.round((30.0 + (double)this.weight / 7500.0) / 20.0);
        this.setSailIntegrity(n);
    }

    public void initializeKFIntegrity() {
        int n = (int)Math.round(1.2 + 0.95 * (double)this.weight / 60000.0);
        this.setKFIntegrity(n);
    }

    public boolean canJump() {
        return this.kf_integrity > 0;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public int getStandardDamage(int n) {
        return this.standard_damage[n];
    }

    public void resetStandardDamage() {
        for (int i = 0; i < this.locations(); ++i) {
            this.standard_damage[i] = 0;
        }
    }

    public void addStandardDamage(int n, HitData hitData) {
        this.standard_damage[hitData.getLocation()] = this.standard_damage[hitData.getLocation()] + n;
    }

    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        int n2 = 11;
        switch (mounted.getLocation()) {
            case 0: {
                n2 = 11;
                break;
            }
            case 2: {
                n2 = 17;
                break;
            }
            case 1: {
                n2 = 16;
                break;
            }
            case 5: {
                n2 = 19;
                break;
            }
            case 4: {
                n2 = 18;
                break;
            }
            case 3: {
                n2 = 22;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return this.rollArcs(n2);
    }

    public HitData rollHitLocation(int n, int n2) {
        int n3 = Compute.d6(2);
        if (n2 == 0) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(15);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(3);
                    return new HitData(0, false, 0);
                }
                case 4: {
                    this.setPotCrit(2);
                    return new HitData(2, false, 0);
                }
                case 5: {
                    this.setPotCrit(17);
                    return new HitData(2, false, 0);
                }
                case 6: {
                    this.setPotCrit(18);
                    return new HitData(0, false, 0);
                }
                case 7: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 8: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 9: {
                    this.setPotCrit(16);
                    return new HitData(1, false, 0);
                }
                case 10: {
                    this.setPotCrit(2);
                    return new HitData(1, false, 0);
                }
                case 11: {
                    this.setPotCrit(0);
                    return new HitData(0, false, 0);
                }
                case 12: {
                    this.setPotCrit(19);
                    return new HitData(0, false, 0);
                }
            }
        } else if (n2 == 2) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(8);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(4);
                    return new HitData(1, false, 0);
                }
                case 4: {
                    this.setPotCrit(2);
                    return new HitData(1, false, 0);
                }
                case 5: {
                    this.setPotCrit(12);
                    return new HitData(1, false, 0);
                }
                case 6: {
                    this.setPotCrit(19);
                    return new HitData(1, false, 0);
                }
                case 7: {
                    this.setPotCrit(21);
                    return new HitData(4, false, 0);
                }
                case 8: {
                    this.setPotCrit(20);
                    return new HitData(4, false, 0);
                }
                case 9: {
                    this.setPotCrit(13);
                    return new HitData(4, false, 0);
                }
                case 10: {
                    this.setPotCrit(2);
                    return new HitData(4, false, 0);
                }
                case 11: {
                    this.setPotCrit(11);
                    return new HitData(3, false, 0);
                }
                case 12: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
            }
        } else if (n2 == 3) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(8);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(4);
                    return new HitData(2, false, 0);
                }
                case 4: {
                    this.setPotCrit(2);
                    return new HitData(2, false, 0);
                }
                case 5: {
                    this.setPotCrit(12);
                    return new HitData(2, false, 0);
                }
                case 6: {
                    this.setPotCrit(19);
                    return new HitData(2, false, 0);
                }
                case 7: {
                    this.setPotCrit(21);
                    return new HitData(5, false, 0);
                }
                case 8: {
                    this.setPotCrit(20);
                    return new HitData(5, false, 0);
                }
                case 9: {
                    this.setPotCrit(13);
                    return new HitData(5, false, 0);
                }
                case 10: {
                    this.setPotCrit(2);
                    return new HitData(5, false, 0);
                }
                case 11: {
                    this.setPotCrit(11);
                    return new HitData(3, false, 0);
                }
                case 12: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
            }
        } else if (n2 == 1) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(7);
                    return new HitData(3, false, 0);
                }
                case 3: {
                    this.setPotCrit(8);
                    return new HitData(3, false, 0);
                }
                case 4: {
                    this.setPotCrit(2);
                    return new HitData(5, false, 0);
                }
                case 5: {
                    this.setPotCrit(17);
                    return new HitData(5, false, 0);
                }
                case 6: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 7: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
                case 8: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 9: {
                    this.setPotCrit(16);
                    return new HitData(4, false, 0);
                }
                case 10: {
                    this.setPotCrit(2);
                    return new HitData(4, false, 0);
                }
                case 11: {
                    this.setPotCrit(3);
                    return new HitData(3, false, 0);
                }
                case 12: {
                    this.setPotCrit(19);
                    return new HitData(3, false, 0);
                }
            }
        }
        return new HitData(0, false, 0);
    }

    public int getMaxEngineHits() {
        return 6;
    }

    public int calculateBattleValue(boolean bl, boolean bl2) {
        int n;
        double d;
        double n10;
        int hashMap;
        Object object;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = 0;
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(0x200000000000L)) continue;
            n3 += mounted.getBaseDamageCapacity() - mounted.getDamageTaken();
        }
        d3 += (double)(this.getTotalArmor() + n3) * 25.0;
        d3 += (double)this.getSI() * 20.0;
        double d5 = 0.0;
        for (Mounted serializable2 : this.getEquipment()) {
            object = serializable2.getType();
            if (serializable2.isDestroyed()) continue;
            if (object instanceof WeaponType && ((EquipmentType)object).hasFlag(0x800000L) || object instanceof AmmoType && ((AmmoType)object).getAmmoType() == 62 || object instanceof WeaponType && ((WeaponType)object).getAtClass() == 21) {
                d5 += ((EquipmentType)object).getBV(this);
            }
            if (!(object instanceof AmmoType) || ((AmmoType)object).getAmmoType() != 14) continue;
            double treeMap = serializable2.getShotsLeft() / ((AmmoType)object).getShots();
            d5 += ((EquipmentType)object).getBV(this) * treeMap;
        }
        d3 += d5;
        d3 *= this.getBVTypeModifier();
        int n4 = this.getHeatCapacity();
        TreeMap<Object, Double> treeMap = new TreeMap<Object, Double>();
        object = new TreeMap();
        TreeMap<Integer, Double> treeMap2 = new TreeMap<Integer, Double>();
        for (Mounted mounted : this.getTotalWeaponList()) {
            Object d9;
            WeaponType n6 = (WeaponType)mounted.getType();
            double n7 = n6.getHeat();
            int d13 = this.getWeaponArc(this.getEquipmentNum(mounted));
            double d2 = n6.getBV(this);
            if (n6 instanceof BayWeapon || n6.hasFlag(0x800000L) || n6.getAtClass() == 21 || mounted.isMissing() || mounted.isHit() || mounted.isDestroyed() || mounted.isBreached()) continue;
            if (n6.getAmmoType() == 20 || n6.getAmmoType() == 33) {
                n7 *= 2.0;
            }
            if (n6.getAmmoType() == 23) {
                n7 *= 6.0;
            }
            if (!(n6.hasFlag(131072L) && n6.getAmmoType() != 46 || n6.hasFlag(16384L) || n6.hasFlag(2048L) || n6.getAmmoType() == -1)) {
                d9 = n6.getAmmoType() + ":" + n6.getRackSize() + ";" + d13;
                if (!treeMap.containsKey(d9)) {
                    treeMap.put(d9, n6.getBV(this));
                } else {
                    treeMap.put(d9, n6.getBV(this) + (Double)treeMap.get(d9));
                }
            }
            if (n6.hasFlag(0x100000000L)) {
                double d6 = 0.0;
                for (Mounted d16 : this.getTotalWeaponList()) {
                    if (!d16.getType().hasFlag(512L) || d16.getLocation() != mounted.getLocation()) continue;
                    d6 += d16.getType().getBV(this);
                }
                d2 = d6 * 0.67;
            }
            if (n6.hasFlag(1L) && this.hasTargComp()) {
                d2 *= 1.25;
            }
            if (mounted.getLinkedBy() != null) {
                d9 = mounted.getLinkedBy();
                if (((Mounted)d9).getType() instanceof MiscType && ((Mounted)d9).getType().hasFlag(512L)) {
                    d2 *= 1.2;
                }
                if (((Mounted)d9).getType() instanceof MiscType && ((Mounted)d9).getType().hasFlag(0x1000000000000L)) {
                    d2 *= 1.15;
                }
            }
            double object2 = 0.0;
            double d7 = 0.0;
            if (null != ((TreeMap)object).get(d13)) {
                object2 = (Double)((TreeMap)object).get(d13);
            }
            if (null != treeMap2.get(d13)) {
                d7 = (Double)treeMap2.get(d13);
            }
            ((TreeMap)object).put(d13, object2 + d2);
            treeMap2.put(d13, d7 + n7);
        }
        double d8 = 0.0;
        int n2 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = Integer.MIN_VALUE;
        double d9 = 1.0;
        double d10 = 0.5;
        double d11 = 0.0;
        double d12 = 0.0;
        Set set = ((TreeMap)object).keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashMap = (Integer)iterator.next();
            if (!((Double)((TreeMap)object).get(hashMap) > d11) || hashMap != 11 && hashMap != 20 && hashMap != 21 && hashMap != 22) continue;
            n2 = hashMap;
            d11 = (Double)((TreeMap)object).get(hashMap);
        }
        if (n2 > Integer.MIN_VALUE) {
            d12 += ((Double)treeMap2.get(n2)).doubleValue();
            hashMap = this.getAdjacentArcCW(n2);
            int arrayList = this.getAdjacentArcCCW(n2);
            double d13 = 0.0;
            n10 = 0.0;
            if (hashMap > Integer.MIN_VALUE && null != ((TreeMap)object).get(hashMap)) {
                d13 = (Double)((TreeMap)object).get(hashMap);
                n10 = (Double)treeMap2.get(hashMap);
            }
            double string = 0.0;
            double d14 = 0.0;
            if (arrayList > Integer.MIN_VALUE && null != ((TreeMap)object).get(arrayList)) {
                string = (Double)((TreeMap)object).get(arrayList);
                d14 = (Double)treeMap2.get(arrayList);
            }
            if (d13 > string) {
                n5 = hashMap;
                if (d12 + n10 > (double)n4) {
                    d9 = 0.5;
                }
                d12 += n10;
                n6 = arrayList;
                if (d12 + d14 > (double)n4) {
                    d10 = 0.25;
                }
            } else {
                n5 = arrayList;
                if (d12 + d14 > (double)n4) {
                    d9 = 0.5;
                }
                d12 += d14;
                n6 = hashMap;
                if (d12 + n10 > (double)n4) {
                    d10 = 0.25;
                }
            }
        }
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Mounted mounted : this.getAmmo()) {
            int n7 = this.getWeaponArc(this.getEquipmentNum(mounted));
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14 || ammoType.getAmmoType() == 62 || mounted.getLocation() == -1) continue;
            String n11 = ammoType.getAmmoType() + ":" + ammoType.getRackSize() + ";" + n7;
            d = mounted.getShotsLeft() / ammoType.getShots();
            if (ammoType.isCapital()) {
                d = (double)mounted.getShotsLeft() * ammoType.getAmmoRatio();
            }
            if (ammoType.hasFlag(2048L)) {
                d = mounted.getShotsLeft();
            }
            if (!arrayList.contains(n11)) {
                arrayList.add(n11);
            }
            if (!hashMap2.containsKey(n11)) {
                hashMap2.put(n11, d * ammoType.getBV(this));
                continue;
            }
            hashMap2.put(n11, d * ammoType.getBV(this) + (Double)hashMap2.get(n11));
        }
        for (String string : arrayList) {
            n10 = 0.0;
            int miscType = Integer.parseInt(string.split(";")[1]);
            if (treeMap.get(string) != null) {
                n10 = (Double)hashMap2.get(string) > (Double)treeMap.get(string) ? (n10 += ((Double)treeMap.get(string)).doubleValue()) : (n10 += ((Double)hashMap2.get(string)).doubleValue());
            }
            d = 0.0;
            if (null != ((TreeMap)object).get(miscType)) {
                d = (Double)((TreeMap)object).get(miscType);
            }
            ((TreeMap)object).put(miscType, d + n10);
        }
        if (n2 > Integer.MIN_VALUE) {
            d8 += ((Double)((TreeMap)object).get(n2)).doubleValue();
            ((TreeMap)object).put(n2, 0.0);
            if (n5 > Integer.MIN_VALUE && null != ((TreeMap)object).get(n5)) {
                d8 += d9 * (Double)((TreeMap)object).get(n5);
                ((TreeMap)object).put(n5, 0.0);
            }
            if (n6 > Integer.MIN_VALUE && null != ((TreeMap)object).get(n6)) {
                d8 += d10 * (Double)((TreeMap)object).get(n6);
                ((TreeMap)object).put(n6, 0.0);
            }
            set = ((TreeMap)object).keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                int d20 = (Integer)iterator.next();
                d8 += 0.25 * (Double)((TreeMap)object).get(d20);
            }
        }
        double d15 = 0.0;
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (mounted.isDestroyed() || miscType.hasFlag(1024L)) continue;
            d = miscType.getBV(this);
            d15 += d;
        }
        d8 += d15;
        int n8 = this.getRunMP();
        if (!(this instanceof Warship) && !(this instanceof SpaceStation)) {
            n8 = 1;
        }
        double d16 = Math.pow(1.0 + ((double)n8 - 5.0) / 10.0, 1.2);
        d16 = (double)Math.round(d16 * 100.0) / 100.0;
        d4 = d8 * d16;
        d = 0.0;
        if ((this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.c3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5) && !bl && this.game != null) {
            n = 0;
            n += this.calculateBattleValue(true, true);
            for (Entity entity : this.game.getC3NetworkMembers(this)) {
                if (this.equals(entity) || !this.onSameC3NetworkAs(entity)) continue;
                n += entity.calculateBattleValue(true, true);
            }
            n = (int)((double)n * 0.05);
            d += (double)n;
        }
        n = (int)Math.round(d3 + d4 + d);
        double d17 = 1.0;
        if (!bl2) {
            d17 = this.crew.getBVSkillMultiplier();
        }
        int n9 = (int)Math.round((double)n * d17);
        if (bl) {
            return n;
        }
        return n9;
    }

    public int getArcswGuns() {
        int n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            if (!this.hasWeaponInArc(i)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasWeaponInArc(int n) {
        boolean bl = false;
        for (Mounted mounted : this.getWeaponList()) {
            if (mounted.getLocation() != n) continue;
            bl = true;
        }
        return bl;
    }

    public double getFuelPerTon() {
        double d = 10.0;
        if (this.weight >= 250000.0f) {
            d = 2.5;
            return d;
        }
        if (this.weight >= 110000.0f) {
            d = 5.0;
            return d;
        }
        return d;
    }

    public double getArmorWeight(int n) {
        double d = this.getTotalOArmor();
        d -= (double)Math.round((double)(this.get0SI() * n) / 10.0);
        double d2 = 0.8;
        if (this.isClan()) {
            d2 = 1.0;
        }
        if (this.weight >= 250000.0f) {
            d2 = 0.4;
            if (this.isClan()) {
                d2 = 0.5;
            }
        } else if (this.weight >= 150000.0f) {
            d2 = 0.6;
            if (this.isClan()) {
                d2 = 0.7;
            }
        }
        if (this.armorType == 13) {
            d2 += 0.2;
        } else if (this.armorType == 11) {
            d2 += 0.4;
        } else if (this.armorType == 12) {
            d2 += 0.6;
        }
        double d3 = d2;
        double d4 = 0.0;
        while (d4 * d3 < d) {
            d4 += 0.5;
        }
        return d4;
    }

    public double getCost() {
        double d = 0.0;
        d += 200000.0;
        d += 200000.0;
        d += (double)(5000 * (this.getNCrew() + this.getNPassenger()));
        d += 80000.0;
        d += 100000.0;
        d += (double)(10000 * this.getArcswGuns());
        d += (double)(100000 * this.getSI());
        d += (double)(25000.0f + 10.0f * this.getWeight());
        d += (double)(100000 * this.getDocks());
        double d2 = (double)this.weight * 0.012;
        d += d2 * 1000.0;
        d += (double)((float)(500 * this.getOriginalWalkMP()) * this.weight) / 100.0;
        d += 1000.0;
        if (this.hasHPG()) {
            d += 1.0E9;
        }
        d += (double)(200 * this.getFuel()) / this.getFuelPerTon();
        d += this.getArmorWeight(this.locations()) * EquipmentType.getArmorCost(this.armorType);
        int n = 2000 + 4000 * this.getHeatType();
        d += (double)(n * this.getHeatSinks());
        double d3 = 0.0;
        d3 += (double)(60000000 + 75000000 * this.getDocks());
        d3 += (double)(25000000 + 5000000 * this.getDocks());
        d3 += 5.0E7;
        d3 += (double)(50000 * this.getKFIntegrity());
        d3 += (double)(50000.0f * (30.0f + this.weight / 7500.0f));
        d3 += (double)(500000 + 200000 * this.getDocks());
        if (this.hasLF()) {
            d3 *= 3.0;
        }
        d += d3;
        d += (double)(5000000 * this.getGravDeck());
        d += (double)(10000000 * this.getGravDeckLarge());
        d += (double)(40000000 * this.getGravDeckHuge());
        d += (double)this.getWeaponsAndEquipmentCost();
        int n2 = 0;
        int n3 = 0;
        for (Bay bay : this.getTransportBays()) {
            n2 += bay.getDoors();
            if (bay instanceof MechBay || bay instanceof ASFBay || bay instanceof SmallCraftBay) {
                n3 += 20000 * bay.totalSpace;
            }
            if (!(bay instanceof LightVehicleBay) && !(bay instanceof HeavyVehicleBay)) continue;
            n3 += 20000 * bay.totalSpace;
        }
        d += (double)(n3 + n2 * 1000);
        double d4 = 1.25;
        return Math.round((d += (double)(5000 * (this.getLifeBoats() + this.getEscapePods()))) * d4);
    }

    public boolean doomedOnGround() {
        return true;
    }

    public boolean doomedInAtmosphere() {
        return true;
    }

    public boolean doomedInSpace() {
        return false;
    }

    public boolean loadWeapon(Mounted mounted, Mounted mounted2) {
        boolean bl = false;
        WeaponType weaponType = (WeaponType)mounted.getType();
        AmmoType ammoType = (AmmoType)mounted2.getType();
        if (mounted.getLocation() != mounted2.getLocation()) {
            return bl;
        }
        Mounted mounted3 = this.whichBay(this.getEquipmentNum(mounted));
        if (mounted3 != null && !mounted3.ammoInBay(this.getEquipmentNum(mounted2))) {
            return bl;
        }
        if (mounted2.isAmmoUsable() && !weaponType.hasFlag(16384L) && ammoType.getAmmoType() == weaponType.getAmmoType() && ammoType.getRackSize() == weaponType.getRackSize()) {
            mounted.setLinked(mounted2);
            bl = true;
        }
        return bl;
    }

    public int getHQIniBonus() {
        return 2;
    }

    public int getOppositeLocation(int n) {
        switch (n) {
            case 0: {
                return 3;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    public boolean hasActiveECM() {
        if (!this.game.getOptions().booleanOption("stratops_ecm") || !this.game.getBoard().inSpace()) {
            return super.hasActiveECM();
        }
        return this.getECMRange() >= 0;
    }

    public int getECMRange() {
        if (!this.game.getOptions().booleanOption("stratops_ecm") || !this.game.getBoard().inSpace()) {
            return super.getECMRange();
        }
        if (!this.isMilitary()) {
            return -1;
        }
        int n = 1;
        n = n - this.getSensorHits() - this.getCICHits();
        return n;
    }

    public boolean isCrewProtected() {
        return this.isMilitary() && this.getOriginalWalkMP() > 4;
    }

    public double getAccumulatedThrust() {
        return this.accumulatedThrust;
    }

    public void setAccumulatedThrust(double d) {
        this.accumulatedThrust = d;
    }

    public double getStationKeepingThrust() {
        return this.stationThrust;
    }

    public void newRound(int n) {
        super.newRound(n);
        if (this.isDeployed() && this.getAccumulatedThrust() < 1.0) {
            this.setAccumulatedThrust(this.getAccumulatedThrust() + this.stationThrust);
        }
    }

    public int getRunMP(boolean bl, boolean bl2) {
        if (this instanceof Warship) {
            return super.getRunMP(bl, bl2);
        }
        return (int)Math.floor(this.getAccumulatedThrust());
    }

    public int getAdjacentArcCW(int n) {
        switch (n) {
            case 11: {
                return 17;
            }
            case 16: {
                return 11;
            }
            case 17: {
                return 19;
            }
            case 18: {
                return 16;
            }
            case 19: {
                return 22;
            }
            case 22: {
                return 18;
            }
        }
        return Integer.MIN_VALUE;
    }

    public int getAdjacentArcCCW(int n) {
        switch (n) {
            case 11: {
                return 16;
            }
            case 17: {
                return 11;
            }
            case 16: {
                return 18;
            }
            case 18: {
                return 22;
            }
            case 19: {
                return 17;
            }
            case 22: {
                return 19;
            }
        }
        return Integer.MIN_VALUE;
    }

    public double getBVTypeModifier() {
        return 0.75;
    }
}

