/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.xml;

import gd.xml.tiny.ParsedXML;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import megamek.common.IGame;
import megamek.common.Minefield;
import megamek.common.Player;
import megamek.common.xml.MinefieldEncoder;

public class PlayerEncoder {
    public static void encode(Player player, Writer writer) throws IOException {
        if (null == player) {
            throw new IllegalArgumentException("The player is null.");
        }
        if (null == writer) {
            throw new IllegalArgumentException("The writer is null.");
        }
        writer.write("<player version=\"1.0\" >");
        writer.write("<playerData id=\"");
        writer.write(player.getId());
        writer.write("\" name=\"");
        writer.write(player.getName());
        writer.write("\" team=\"");
        writer.write(player.getTeam());
        writer.write("\" colorIndex=\"");
        writer.write(player.getColorIndex());
        writer.write("\" camoFileName=\"");
        writer.write(player.getCamoFileName());
        writer.write("\" startingPos=\"");
        writer.write(player.getStartingPos());
        writer.write("\" numConvMF=\"");
        writer.write(player.getNbrMFConventional());
        writer.write("\" numCommandMF=\"");
        writer.write(player.getNbrMFCommand());
        writer.write("\" numVibroMF=\"");
        writer.write(player.getNbrMFVibra());
        writer.write("\" isDone=\"");
        writer.write(player.isDone() ? "true" : "false");
        writer.write("\" isGhost=\"");
        writer.write(player.isGhost() ? "true" : "false");
        writer.write("\" isObserver=\"");
        writer.write(player.isObserver() ? "true" : "false");
        writer.write("\" isSeeAll=\"");
        writer.write(player.getSeeAll() ? "true" : "false");
        writer.write("\" admitsDefeat=\"");
        writer.write(player.admitsDefeat() ? "true" : "false");
        writer.write("\" />");
        Enumeration<Minefield> enumeration = player.getMinefields().elements();
        if (enumeration.hasMoreElements()) {
            writer.write("<minefields>");
            while (enumeration.hasMoreElements()) {
                MinefieldEncoder.encode(enumeration.nextElement(), writer);
            }
        }
        writer.write("</minefields>");
        writer.write("</player>");
    }

    public static Player decode(ParsedXML parsedXML, IGame iGame) {
        return null;
    }
}

