/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.type;

import com.google.common.collect.ImmutableMap;
import javax.inject.Inject;
import org.gradle.api.artifacts.type.ArtifactTypeContainer;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.artifacts.type.DefaultArtifactTypeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.reflect.Instantiator;

public class ArtifactTypeRegistry {
    private final Instantiator instantiator;
    private final AttributesFactory attributesFactory;
    private final CollectionCallbackActionDecorator callbackActionDecorator;
    private final AttributeContainerInternal defaultArtifactAttributes;
    private ArtifactTypeContainer artifactTypeDefinitions;

    @Inject
    public ArtifactTypeRegistry(Instantiator instantiator, AttributesFactory attributesFactory, CollectionCallbackActionDecorator callbackActionDecorator) {
        this.instantiator = instantiator;
        this.attributesFactory = attributesFactory;
        this.callbackActionDecorator = callbackActionDecorator;
        this.defaultArtifactAttributes = attributesFactory.mutable();
    }

    public AttributeContainerInternal getDefaultArtifactAttributes() {
        return this.defaultArtifactAttributes;
    }

    public ArtifactTypeContainer getArtifactTypeContainer() {
        if (this.artifactTypeDefinitions == null) {
            this.artifactTypeDefinitions = (ArtifactTypeContainer)this.instantiator.newInstance(DefaultArtifactTypeContainer.class, new Object[]{this.instantiator, this.attributesFactory, this.callbackActionDecorator});
        }
        return this.artifactTypeDefinitions;
    }

    public ImmutableMap<String, ImmutableAttributes> getArtifactTypeMappings() {
        if (this.artifactTypeDefinitions == null) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ArtifactTypeDefinition artifactTypeDefinition : this.artifactTypeDefinitions) {
            ImmutableAttributes attributes = ((AttributeContainerInternal)artifactTypeDefinition.getAttributes()).asImmutable();
            builder.put((Object)artifactTypeDefinition.getName(), (Object)attributes);
        }
        return builder.build();
    }
}

