/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog.examples;

import com.declarativa.interprolog.ObjectExamplePair;
import com.declarativa.interprolog.PrologEngine;
import com.declarativa.interprolog.XSBSubprocessEngine;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import javax.swing.DefaultCellEditor;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SudokuWindow
extends JFrame {
    SudokuModel model;
    PrologEngine engine;
    static /* synthetic */ Class class$com$declarativa$interprolog$examples$SudokuWindow;
    static /* synthetic */ Class class$java$lang$Integer;

    public SudokuWindow(PrologEngine prologEngine) {
        this.engine = prologEngine;
        this.engine.consultFromPackage("Sudoku.P", class$com$declarativa$interprolog$examples$SudokuWindow != null ? class$com$declarativa$interprolog$examples$SudokuWindow : (class$com$declarativa$interprolog$examples$SudokuWindow = SudokuWindow.class$("com.declarativa.interprolog.examples.SudokuWindow")));
        ObjectExamplePair[] objectExamplePairArray = new ObjectExamplePair[]{SudokuWindow.getNxNintArrayExample(), SudokuWindow.singleCellValue(), SudokuWindow.arrayOfCellValue()};
        if (!this.engine.teachMoreObjects(objectExamplePairArray)) {
            throw new RuntimeException("failed to teach object examples");
        }
        this.setJMenuBar(this.buildMenus());
        this.model = new SudokuModel();
        SudokuBoard sudokuBoard = new SudokuBoard(this.model);
        this.getContentPane().add("Center", sudokuBoard);
        this.pack();
        this.show();
    }

    static ObjectExamplePair getNxNintArrayExample() {
        int[][] nArray = new int[9][9];
        int[][] nArray2 = new int[nArray.length][nArray.length];
        int n = 0;
        while (n < nArray2.length) {
            int n2 = 0;
            while (n2 < nArray2.length) {
                nArray[n][n2] = 1;
                nArray2[n][n2] = 2;
                ++n2;
            }
            ++n;
        }
        return new ObjectExamplePair("NxNintArray", nArray, nArray2);
    }

    static ObjectExamplePair singleCellValue() {
        return new ObjectExamplePair(new CellValue());
    }

    static ObjectExamplePair arrayOfCellValue() {
        return new ObjectExamplePair("CellArray", (Object)new CellValue[0]);
    }

    JMenuBar buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Puzzle");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("New");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new 1());
        JMenuItem jMenuItem2 = new JMenuItem("Open File");
        jMenu.add(jMenuItem2);
        jMenuItem2.addActionListener(new 2());
        JMenuItem jMenuItem3 = new JMenuItem("Load from PROLOG");
        jMenu.add(jMenuItem3);
        jMenuItem3.addActionListener(new 3());
        JMenuItem jMenuItem4 = new JMenuItem("Save");
        jMenu.add(jMenuItem4);
        jMenuItem4.addActionListener(new 4());
        JMenuItem jMenuItem5 = new JMenuItem("Solve");
        jMenuItem5.addActionListener(new 5());
        jMenu.add(jMenuItem5);
        return jMenuBar;
    }

    public static void main(String[] stringArray) {
        XSBSubprocessEngine xSBSubprocessEngine = new XSBSubprocessEngine();
        SudokuWindow sudokuWindow = new SudokuWindow(xSBSubprocessEngine);
        sudokuWindow.addWindowListener(new 6(xSBSubprocessEngine));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class CellValue
    implements Serializable {
        int X;
        int Y;
        int N;

        int getMyX() {
            return this.X - 1;
        }

        int getMyY() {
            return this.Y - 1;
        }

        CellValue() {
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SudokuWindow.this.engine.deterministicGoal("newPuzzle")) {
                throw new RuntimeException("Prolog goal should not have failed!");
            }
            SudokuWindow.this.model.clean();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            File file = null;
            FileDialog fileDialog = new FileDialog((Frame)SudokuWindow.this, "Open puzzle...");
            ((Component)fileDialog).setVisible(true);
            String string = fileDialog.getFile();
            String string2 = fileDialog.getDirectory();
            if (string != null) {
                file = new File(string2, string);
                if (!SudokuWindow.this.engine.deterministicGoal("newPuzzle")) {
                    throw new RuntimeException("Prolog newPuzzle goal should not have failed!");
                }
                if (SudokuWindow.this.engine.consultAbsolute(file)) {
                    Object[] objectArray = SudokuWindow.this.engine.deterministicGoal("openPuzzle('" + file.getAbsolutePath() + "',Array)", "[Array]");
                    if (objectArray == null) {
                        throw new RuntimeException("Prolog openPuzzle goal should not have failed!");
                    }
                    SudokuWindow.this.model.setCells((int[][])objectArray[0]);
                } else {
                    throw new RuntimeException("Prolog consult should not have failed!");
                }
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = SudokuWindow.this.engine.deterministicGoal("loadPuzzle(Array)", "[Array]");
            if (objectArray == null) {
                throw new RuntimeException("Prolog loadPuzzle goal should not have failed!");
            }
            SudokuWindow.this.model.setCells((int[][])objectArray[0]);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            File file = null;
            FileDialog fileDialog = new FileDialog((Frame)SudokuWindow.this, "Save puzzle...", 1);
            ((Component)fileDialog).setVisible(true);
            String string = fileDialog.getFile();
            String string2 = fileDialog.getDirectory();
            if (string != null) {
                file = new File(string2, string);
                if (!SudokuWindow.this.engine.deterministicGoal("assertBoard(Matrix), savePuzzle('" + file.getAbsolutePath() + "')", "[Matrix]", new Object[]{SudokuWindow.this.model.cells})) {
                    throw new RuntimeException("Prolog goal should not have failed!");
                }
            }
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = SudokuWindow.this.engine.deterministicGoal("assertBoard(Matrix), resolve(L), prepareSolutionCells(L,SL), ipObjectSpec('CellArray',SL,Solution)", "[Matrix]", new Object[]{SudokuWindow.this.model.cells}, "[Solution]");
            if (objectArray == null) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(SudokuWindow.this, "Puzzle has no solution", "Prolog failure", 0);
            } else {
                SudokuWindow.this.model.setCells((CellValue[])objectArray[0]);
            }
        }

        /* synthetic */ 5() {
        }
    }

    static class SudokuBoard
    extends JTable {
        public SudokuBoard(TableModel tableModel) {
            super(tableModel);
            this.setCellSelectionEnabled(true);
            this.setAutoResizeMode(0);
            TableColumnModel tableColumnModel = this.getColumnModel();
            Font font = this.getFont().deriveFont(20.0f);
            this.setFont(font);
            int n = ((Component)this).getFontMetrics(font).getMaxAdvance();
            this.setDefaultRenderer(class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = SudokuWindow.class$("java.lang.Integer")), new MyCellRenderer());
            int n2 = 0;
            while (n2 < tableColumnModel.getColumnCount()) {
                tableColumnModel.getColumn(n2).setMaxWidth(n);
                ++n2;
            }
            this.setRowHeight(n);
        }

        public void paint(Graphics graphics) {
            int n;
            super.paint(graphics);
            graphics.setColor(Color.black);
            int n2 = 3;
            while (n2 < 9) {
                n = n2 * this.getRowHeight();
                graphics.drawLine(0, n - 1, this.getWidth() - 1, n - 1);
                n2 += 3;
            }
            n = 3;
            while (n < 9) {
                int n3 = this.getCellRect((int)0, (int)n, (boolean)true).x;
                graphics.drawLine(n3 - 1, 0, n3 - 1, this.getHeight() - 1);
                n += 3;
            }
        }

        public TableCellEditor getDefaultEditor(Class clazz) {
            DefaultCellEditor defaultCellEditor = (DefaultCellEditor)super.getDefaultEditor(clazz);
            defaultCellEditor.getComponent().setFont(this.getFont());
            return defaultCellEditor;
        }
    }

    static class MyCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (jTable.getModel().isCellEditable(n, n2)) {
                component.setForeground(Color.black);
            } else {
                component.setForeground(Color.blue);
            }
            ((JLabel)component).setHorizontalAlignment(0);
            component.setFont(jTable.getFont());
            return component;
        }

        MyCellRenderer() {
        }
    }

    static class SudokuModel
    extends AbstractTableModel
    implements Serializable {
        int[][] cells = new int[9][9];
        boolean[][] given = new boolean[this.getRowCount()][this.getColumnCount()];

        SudokuModel() {
            this.clean();
        }

        void clean() {
            int n = 0;
            while (n < this.getRowCount()) {
                int n2 = 0;
                while (n2 < this.getColumnCount()) {
                    this.cells[n][n2] = 0;
                    this.given[n][n2] = false;
                    ++n2;
                }
                ++n;
            }
            this.fireTableDataChanged();
        }

        int cellY(int n) {
            return this.getRowCount() - 1 - n;
        }

        public int getRowCount() {
            return this.cells.length;
        }

        public int getColumnCount() {
            return this.cells[0].length;
        }

        public Class getColumnClass(int n) {
            return class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = SudokuWindow.class$("java.lang.Integer"));
        }

        public Object getValueAt(int n, int n2) {
            int n3 = this.cells[this.cellY(n)][n2];
            if (n3 == 0) {
                return null;
            }
            return new Integer(n3);
        }

        public boolean isCellEditable(int n, int n2) {
            return !this.given[this.cellY(n)][n2];
        }

        public void setValueAt(Object object, int n, int n2) {
            int n3 = 0;
            if (object != null) {
                n3 = (Integer)object;
            }
            int n4 = this.cells[this.cellY(n)][n2];
            if (n3 < 0 || n3 > this.getRowCount()) {
                n3 = n4;
            }
            this.cells[this.cellY((int)n)][n2] = n3;
        }

        public void setCells(int[][] nArray) {
            if (nArray != null) {
                this.cells = nArray;
                int n = 0;
                while (n < this.getRowCount()) {
                    int n2 = 0;
                    while (n2 < this.getColumnCount()) {
                        this.given[n][n2] = nArray[n][n2] != 0;
                        ++n2;
                    }
                    ++n;
                }
                this.fireTableDataChanged();
            }
        }

        public void setCells(CellValue[] cellValueArray) {
            if (cellValueArray != null) {
                int n = 0;
                while (n < cellValueArray.length) {
                    CellValue cellValue = cellValueArray[n];
                    this.cells[cellValue.getMyY()][cellValue.getMyX()] = cellValue.N;
                    ++n;
                }
                this.fireTableDataChanged();
            }
        }
    }

    private static final class 6
    extends WindowAdapter {
        private final /* synthetic */ XSBSubprocessEngine val$engine;

        public void windowClosing(WindowEvent windowEvent) {
            this.val$engine.shutdown();
            System.exit(0);
        }

        /* synthetic */ 6(XSBSubprocessEngine xSBSubprocessEngine) {
            this.val$engine = xSBSubprocessEngine;
        }
    }
}

