/*
 * Decompiled with CFR 0.152.
 */
package com.idiominc.ws.opentopic.fo.index2.util;

import com.idiominc.ws.opentopic.fo.index2.IndexEntry;
import com.idiominc.ws.opentopic.fo.index2.util.IndexEntryImpl;
import java.util.ArrayList;
import java.util.List;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.util.Constants;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public final class IndexDitaProcessor {
    private static final String elIndexRangeStartName = "start";
    private static final String elIndexRangeEndName = "end";
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String sortStart = "[";
    private static final String sortEnd = "]";
    private DITAOTLogger logger;

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    public IndexEntry[] processIndexDitaNode(Node theNode, String theParentValue) {
        IndexEntry result;
        NodeList childNodes = theNode.getChildNodes();
        StringBuilder textValueBuffer = new StringBuilder();
        ArrayList<Node> contents = new ArrayList<Node>();
        StringBuilder sortStringBuffer = new StringBuilder();
        boolean startRange = theNode.getAttributes().getNamedItem(elIndexRangeStartName) != null;
        boolean endRange = theNode.getAttributes().getNamedItem(elIndexRangeEndName) != null;
        ArrayList<IndexEntry> childEntrys = new ArrayList<IndexEntry>();
        ArrayList<IndexEntry> seeEntry = new ArrayList<IndexEntry>();
        ArrayList<IndexEntry> seeAlsoEntry = new ArrayList<IndexEntry>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() == 3) {
                contents.add(child);
                String val = child.getNodeValue();
                if (null == val) continue;
                textValueBuffer.append(val);
                continue;
            }
            if (Constants.TOPIC_INDEXTERM.matches(child)) {
                void var15_26;
                IndexEntry[] indexEntryArray;
                String currentTextValue = IndexDitaProcessor.normalizeTextValue(textValueBuffer.toString());
                if (currentTextValue.equals("")) {
                    String string = "";
                } else {
                    String string = currentTextValue + ":";
                }
                for (IndexEntry child2 : indexEntryArray = this.processIndexDitaNode(child, theParentValue + (String)var15_26)) {
                    childEntrys.add(child2);
                }
                continue;
            }
            if (Constants.INDEXING_D_INDEX_SORT_AS.matches(child)) {
                for (int j = 0; j < child.getChildNodes().getLength(); ++j) {
                    String string;
                    Node node = child.getChildNodes().item(j);
                    if (node.getNodeType() != 3 || (string = node.getNodeValue()) == null) continue;
                    sortStringBuffer.append(string);
                }
                continue;
            }
            if (Constants.INDEXING_D_INDEX_SEE.matches(child)) {
                IndexEntry[] childs;
                for (IndexEntry child2 : childs = this.processIndexDitaNode(child, "")) {
                    seeEntry.add(child2);
                }
                continue;
            }
            if (Constants.INDEXING_D_INDEX_SEE_ALSO.matches(child)) {
                IndexEntry[] childs;
                for (IndexEntry child2 : childs = this.processIndexDitaNode(child, "")) {
                    seeAlsoEntry.add(child2);
                }
                continue;
            }
            if (child.getNodeType() != 1) continue;
            contents.add(child);
            textValueBuffer.append(XMLUtils.getStringValue((Element)((Element)child)));
        }
        String textValue = IndexDitaProcessor.normalizeTextValue(textValueBuffer.toString());
        String sortString = sortStringBuffer.toString();
        if (textValue.contains(sortStart) && textValue.contains(sortEnd) && sortString.length() == 0 && textValue.indexOf(sortStart) < textValue.indexOf(sortEnd)) {
            sortString = textValue.substring(textValue.indexOf(sortStart) + 1, textValue.indexOf(sortEnd));
            textValue = textValue.substring(0, textValue.indexOf(sortStart));
        }
        if (!childEntrys.isEmpty() && !seeEntry.isEmpty()) {
            for (IndexEntry indexEntry : seeEntry) {
                this.logger.warn(MessageUtils.getMessage((String)"DOTA067W", (String[])new String[]{indexEntry.getFormattedString(), textValue}).toString());
            }
            seeEntry.clear();
        }
        if (!childEntrys.isEmpty() && !seeAlsoEntry.isEmpty()) {
            for (IndexEntry indexEntry : seeAlsoEntry) {
                this.logger.warn(MessageUtils.getMessage((String)"DOTA068W", (String[])new String[]{indexEntry.getFormattedString(), textValue}).toString());
            }
            seeAlsoEntry.clear();
        }
        if ((result = IndexDitaProcessor.createIndexEntry(contents, textValue, sortString)).getValue().length() > 0 || endRange || startRange) {
            result.setStartRange(startRange);
            result.setEndsRange(endRange);
            if (startRange) {
                result.addRefID(theNode.getAttributes().getNamedItem(elIndexRangeStartName).getNodeValue());
            } else if (endRange) {
                result.addRefID(theNode.getAttributes().getNamedItem(elIndexRangeEndName).getNodeValue());
            } else {
                result.addRefID(IndexDitaProcessor.normalizeTextValue(theParentValue + textValue + ":"));
            }
            if (!seeEntry.isEmpty()) {
                for (IndexEntry indexEntry : seeEntry) {
                    result.addSeeChild(indexEntry);
                }
                result.setSuppressesThePageNumber(true);
            }
            if (!seeAlsoEntry.isEmpty()) {
                for (IndexEntry indexEntry : seeAlsoEntry) {
                    result.addSeeAlsoChild(indexEntry);
                }
            }
            for (IndexEntry indexEntry : childEntrys) {
                result.addChild(indexEntry);
            }
            IndexEntry[] indexEntryArray = new IndexEntry[]{result};
            return indexEntryArray;
        }
        return childEntrys.toArray(new IndexEntry[childEntrys.size()]);
    }

    private static IndexEntry createIndexEntry(List<Node> contents, String theValue, String theSortString) {
        IndexEntryImpl indexEntry = new IndexEntryImpl(theValue, theSortString, theValue, contents);
        if (!theSortString.equals("")) {
            indexEntry.setSortString(theSortString);
        } else {
            indexEntry.setSortString(null);
        }
        return indexEntry;
    }

    private static String stripFormatting(String theValue) {
        int ltPos = theValue.indexOf(LT);
        int gtPos = theValue.indexOf(GT);
        if (ltPos == -1 && gtPos == -1) {
            return theValue;
        }
        if (ltPos == -1 || gtPos == -1 || ltPos > gtPos) {
            System.err.println("Possibly bad formatting in string \"" + theValue + "\"");
            return theValue;
        }
        String value = theValue.substring(0, ltPos) + theValue.substring(gtPos + 1);
        return IndexDitaProcessor.stripFormatting(value);
    }

    public static String normalizeTextValue(String theString) {
        if (null != theString && theString.length() > 0) {
            String res = theString.replaceAll("[\\s\\n]+", " ").trim();
            res = res.replaceAll("[\\s]+$", "");
            return res;
        }
        return theString;
    }
}

