/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dita.dost.invoker.Main;

public class UsageBuilder {
    private final StringBuilder buf = new StringBuilder();
    private final List<String> usages = new ArrayList<String>();
    private final Map<String, String> subcommands = new HashMap<String, String>();
    private final Map<Key, String> options = new HashMap<Key, String>();
    private final Map<Key, String> arguments = new LinkedHashMap<Key, String>();
    private final List<String> footers = new ArrayList<String>();
    private final boolean useColor;

    private UsageBuilder(boolean compact, boolean useColor) {
        this.useColor = useColor;
        this.options("h", "help", null, Main.locale.getString("help.option.help"));
        if (!compact) {
            this.options("d", "debug", null, Main.locale.getString("help.option.debug"));
            this.options("v", "verbose", null, Main.locale.getString("help.option.verbose"));
            this.options(null, "no-color", null, Main.locale.getString("help.option.no-color"));
        }
    }

    public static UsageBuilder builder(boolean compact, boolean useColor) {
        return new UsageBuilder(compact, useColor);
    }

    public UsageBuilder usage(String usage) {
        this.usages.add(usage);
        return this;
    }

    public UsageBuilder subcommands(String subcommand, String desc) {
        this.subcommands.put(subcommand, desc);
        return this;
    }

    public UsageBuilder options(String shortKey, String longKey, String value, String desc) {
        this.options.put(new Key(shortKey, longKey, value), desc);
        return this;
    }

    public UsageBuilder arguments(String shortKey, String longKey, String value, String desc) {
        this.arguments.put(new Key(shortKey, longKey, value), desc);
        return this;
    }

    public UsageBuilder footer(String desc) {
        this.footers.add(desc);
        return this;
    }

    public String build() {
        String padding = this.getPadding();
        this.bold("Usage");
        this.buf.append(":\n");
        for (String string : this.usages) {
            this.buf.append("  ").append(string).append("\n");
        }
        if (!this.subcommands.isEmpty()) {
            this.buf.append("\n");
            this.bold("Subcommands");
            this.buf.append(":\n");
            for (Map.Entry entry : this.sortSubCommands(this.subcommands)) {
                this.buf.append("  ").append((String)entry.getKey()).append(padding.substring(((String)entry.getKey()).length())).append((String)entry.getValue()).append("\n");
            }
            this.buf.append("\n  See 'dita <subcommand> --help' for details about a specific subcommand.\n");
        }
        if (!this.arguments.isEmpty()) {
            this.buf.append("\n");
            this.bold("Arguments");
            this.buf.append(":\n");
            for (Map.Entry entry : this.arguments.entrySet()) {
                this.buf.append("  ").append(entry.getKey()).append(padding.substring(((Key)entry.getKey()).toString().length())).append((String)entry.getValue()).append("\n");
            }
        }
        if (!this.options.isEmpty()) {
            this.buf.append("\n");
            this.bold("Options");
            this.buf.append(":\n");
            for (Map.Entry entry : this.sort(this.options)) {
                this.buf.append("  ").append(entry.getKey()).append(padding.substring(((Key)entry.getKey()).toString().length())).append((String)entry.getValue()).append("\n");
            }
        }
        if (!this.footers.isEmpty()) {
            this.buf.append("\n");
            for (String string : this.footers) {
                this.buf.append(string).append("\n");
            }
        }
        return this.buf.toString();
    }

    private List<Map.Entry<Key, String>> sort(Map<Key, String> arguments) {
        ArrayList<Map.Entry<Key, String>> entries = new ArrayList<Map.Entry<Key, String>>(arguments.entrySet());
        entries.sort(Map.Entry.comparingByKey());
        return entries;
    }

    private void bold(String text) {
        if (this.useColor) {
            this.buf.append("\u001b[1m").append(text).append("\u001b[0m");
        } else {
            this.buf.append(text);
        }
    }

    private List<Map.Entry<String, String>> sortSubCommands(Map<String, String> arguments) {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(arguments.entrySet());
        entries.sort(Map.Entry.comparingByKey());
        return entries;
    }

    private String getPadding() {
        int max = 0;
        for (String string : this.subcommands.keySet()) {
            max = Math.max(max, string.length());
        }
        for (Key key : this.options.keySet()) {
            max = Math.max(max, key.toString().length());
        }
        for (Key key : this.arguments.keySet()) {
            max = Math.max(max, key.toString().length());
        }
        return " ".repeat(Math.max(0, max + 2));
    }

    private record Key(String shortKey, String longKey, String value) implements Comparable<Key>
    {
        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.shortKey != null) {
                buf.append("-").append(this.shortKey);
                if (this.value != null) {
                    buf.append(" <").append(this.value).append(">");
                }
            }
            if (this.shortKey != null && this.longKey != null) {
                buf.append(", ");
            }
            if (this.longKey != null) {
                buf.append("--").append(this.longKey);
                if (this.value != null) {
                    buf.append("=<").append(this.value).append(">");
                }
            }
            if (this.shortKey == null && this.longKey == null & this.value != null) {
                buf.append("<").append(this.value).append(">");
            }
            return buf.toString();
        }

        @Override
        public int compareTo(Key o) {
            if (this.longKey != null && o.longKey != null) {
                return this.longKey.compareTo(o.longKey);
            }
            if (this.value != null && o.value != null) {
                return this.value.compareTo(o.value);
            }
            return 0;
        }
    }
}

