/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.options;

import java.util.List;
import org.rundeck.client.tool.options.ProjectNameOptions;
import picocli.CommandLine;

public class QueryOptions
extends ProjectNameOptions {
    @CommandLine.Option(names={"-d", "--recent"}, description={"Get executions newer than specified time. e.g. \"3m\" (3 months). \nUse: h,n,s,d,w,m,y (hour,minute,second,day,week,month,year)"})
    private String recentFilter;
    @CommandLine.Option(names={"-O", "--older"}, description={"Get executions older than specified time. e.g. \"3m\" (3 months). \nUse: h,n,s,d,w,m,y (hour,minute,second,day,week,month,year)"})
    private String olderFilter;
    @CommandLine.Option(names={"-s", "--status"}, description={"Status filter, one of: running,succeeded,failed,aborted"})
    private String statusFilter;
    @CommandLine.Option(names={"-u", "--user"}, description={"User filter"})
    private String userFilter;
    @CommandLine.Option(names={"-A", "--adhoconly"}, description={"Adhoc executions only"})
    private boolean adhoc;
    @CommandLine.Option(names={"-J", "--jobonly"}, description={"Job executions only"})
    private boolean job;
    @CommandLine.Option(names={"-j", "--jobs"}, arity="1..*", description={"List of Full job group and name to include."})
    private List<String> jobList;
    @CommandLine.Option(names={"-x", "--xjobids"}, arity="1..*", description={"Job ID list to exclude"})
    private List<String> excludeJobIdList;
    @CommandLine.Option(names={"-X", "--xjobs"}, arity="1..*", description={"List of Full job group and name to exclude."})
    private List<String> excludeJobList;
    @CommandLine.Option(names={"-g", "--group"}, description={"Group or partial group path to include, \"-\" means top-level jobs only"})
    private String groupPath;
    @CommandLine.Option(names={"--xgroup"}, description={"Group or partial group path to exclude, \"-\" means top-level jobs only"})
    private String excludeGroupPath;
    @CommandLine.Option(names={"-G", "--groupexact"}, description={"Exact group path to include, \"-\" means top-level jobs only"})
    private String groupPathExact;
    @CommandLine.Option(names={"--xgroupexact"}, description={"Exact group path to exclude, \"-\" means top-level jobs only"})
    private String excludeGroupPathExact;
    @CommandLine.Option(names={"-n", "--name"}, description={"Job Name Filter, include any name that matches this value"})
    private String jobFilter;
    @CommandLine.Option(names={"--xname"}, description={"Exclude Job Name Filter, exclude any name that matches this value"})
    private String excludeJobFilter;
    @CommandLine.Option(names={"-N", "--nameexact"}, description={"Exact Job Name Filter, include any name that is equal to this value"})
    private String jobExactFilter;
    @CommandLine.Option(names={"--xnameexact"}, description={"Exclude Exact Job Name Filter, exclude any name that is equal to this value"})
    private String excludeJobExactFilter;

    public boolean isRecentFilter() {
        return this.recentFilter != null;
    }

    public boolean isOlderFilter() {
        return this.olderFilter != null;
    }

    public boolean isStatusFilter() {
        return this.statusFilter != null;
    }

    public boolean isUserFilter() {
        return this.userFilter != null;
    }

    public boolean isJobList() {
        return this.jobList != null && this.jobList.size() > 0;
    }

    public boolean isExcludeJobIdList() {
        return this.excludeJobIdList != null && !this.excludeJobIdList.isEmpty();
    }

    public boolean isExcludeJobList() {
        return this.excludeJobList != null && !this.excludeJobList.isEmpty();
    }

    public boolean isGroupPath() {
        return this.groupPath != null;
    }

    public boolean isExcludeGroupPath() {
        return this.excludeGroupPath != null;
    }

    public boolean isGroupPathExact() {
        return this.groupPathExact != null;
    }

    public boolean isExcludeGroupPathExact() {
        return this.excludeGroupPathExact != null;
    }

    public boolean isJobFilter() {
        return this.jobFilter != null;
    }

    public boolean isExcludeJobFilter() {
        return this.excludeJobFilter != null;
    }

    public boolean isJobExactFilter() {
        return this.jobExactFilter != null;
    }

    public boolean isExcludeJobExactFilter() {
        return this.excludeJobExactFilter != null;
    }

    public String getRecentFilter() {
        return this.recentFilter;
    }

    public String getOlderFilter() {
        return this.olderFilter;
    }

    public String getStatusFilter() {
        return this.statusFilter;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public boolean isAdhoc() {
        return this.adhoc;
    }

    public boolean isJob() {
        return this.job;
    }

    public List<String> getJobList() {
        return this.jobList;
    }

    public List<String> getExcludeJobIdList() {
        return this.excludeJobIdList;
    }

    public List<String> getExcludeJobList() {
        return this.excludeJobList;
    }

    public String getGroupPath() {
        return this.groupPath;
    }

    public String getExcludeGroupPath() {
        return this.excludeGroupPath;
    }

    public String getGroupPathExact() {
        return this.groupPathExact;
    }

    public String getExcludeGroupPathExact() {
        return this.excludeGroupPathExact;
    }

    public String getJobFilter() {
        return this.jobFilter;
    }

    public String getExcludeJobFilter() {
        return this.excludeJobFilter;
    }

    public String getJobExactFilter() {
        return this.jobExactFilter;
    }

    public String getExcludeJobExactFilter() {
        return this.excludeJobExactFilter;
    }

    public void setRecentFilter(String recentFilter) {
        this.recentFilter = recentFilter;
    }

    public void setOlderFilter(String olderFilter) {
        this.olderFilter = olderFilter;
    }

    public void setStatusFilter(String statusFilter) {
        this.statusFilter = statusFilter;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public void setAdhoc(boolean adhoc) {
        this.adhoc = adhoc;
    }

    public void setJob(boolean job) {
        this.job = job;
    }

    public void setJobList(List<String> jobList) {
        this.jobList = jobList;
    }

    public void setExcludeJobIdList(List<String> excludeJobIdList) {
        this.excludeJobIdList = excludeJobIdList;
    }

    public void setExcludeJobList(List<String> excludeJobList) {
        this.excludeJobList = excludeJobList;
    }

    public void setGroupPath(String groupPath) {
        this.groupPath = groupPath;
    }

    public void setExcludeGroupPath(String excludeGroupPath) {
        this.excludeGroupPath = excludeGroupPath;
    }

    public void setGroupPathExact(String groupPathExact) {
        this.groupPathExact = groupPathExact;
    }

    public void setExcludeGroupPathExact(String excludeGroupPathExact) {
        this.excludeGroupPathExact = excludeGroupPathExact;
    }

    public void setJobFilter(String jobFilter) {
        this.jobFilter = jobFilter;
    }

    public void setExcludeJobFilter(String excludeJobFilter) {
        this.excludeJobFilter = excludeJobFilter;
    }

    public void setJobExactFilter(String jobExactFilter) {
        this.jobExactFilter = jobExactFilter;
    }

    public void setExcludeJobExactFilter(String excludeJobExactFilter) {
        this.excludeJobExactFilter = excludeJobExactFilter;
    }
}

