/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.JSDLCommonSetup;
import com.jgoodies.common.swing.internal.AncestorSupport;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.util.ComponentUtils;
import com.jgoodies.dialogs.core.AspectRatio;
import com.jgoodies.dialogs.core.CloseHandler;
import com.jgoodies.dialogs.core.CloseRequestHandler;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.CoreDialogResources;
import com.jgoodies.dialogs.core.JSDLCoreSetup;
import com.jgoodies.dialogs.core.LayoutType;
import com.jgoodies.dialogs.core.MessageType;
import com.jgoodies.dialogs.core.PreferredWidth;
import com.jgoodies.dialogs.core.internal.CommandBarBuilder;
import com.jgoodies.dialogs.core.internal.CommandValueCommitAction;
import com.jgoodies.dialogs.core.internal.JSDLCoreStyleChecker;
import com.jgoodies.dialogs.core.pane.AbstractStyledPaneVisualConfiguration;
import com.jgoodies.dialogs.core.pane.task.TaskPaneBuilder;
import com.jgoodies.dialogs.core.plaf.basic.StyledPaneUI;
import com.jgoodies.dialogs.core.style.StyleManager;
import com.jgoodies.dialogs.core.util.JSDLUtils;
import com.jgoodies.layout.layout.Sizes;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkListener;

public abstract class AbstractStyledPane<VC extends AbstractStyledPaneVisualConfiguration>
extends JComponent
implements Accessible,
CloseRequestHandler {
    public static final String PROPERTY_COMMIT_VALUE = "commitValue";
    public static final String PROPERTY_MESSAGE_TYPE = "messageType";
    public static final String PROPERTY_CONTENT = "content";
    public static final String PROPERTY_COMMAND_BAR = "commandBar";
    public static final String PROPERTY_CANCEL_ALLOWED = "cancelAllowed";
    public static final String PROPERTY_PREFERRED_WIDTH = "preferredWidth";
    public static final String PROPERTY_ASPECT_RATIO = "aspectRatio";
    public static final String PROPERTY_INITIAL_FOCUS_VISIBLE = "initialFocusVisible";
    public static final String PROPERTY_INITIAL_FOCUS_REQUESTED = "initialFocusRequested";
    public static final Object UNINITIALIZED_VALUE = "uninitializedValue";
    private static final int ASPECT_RATIO_SIZE_INCREMENT = 25;
    private final VC visualConfiguration;
    private Object value = UNINITIALIZED_VALUE;
    private MessageType messageType;
    private JComponent content;
    private JComponent commandBar;
    private final Map<Object, JButton> commitMap = new HashMap<Object, JButton>();
    protected JButton[] commitButtons;
    protected JButton[] additionalCommandButtons;
    protected JButton defaultButton;
    private Object cancelObject;
    private boolean cancelAllowed = false;
    private CloseHandler closeHandler = null;
    private CloseRequestHandler closeRequestHandler = null;
    private HyperlinkListener hyperlinkListener;
    private JSDLDialog dialog;
    private WindowAdapter windowAdapter;
    private ComponentListener componentAdapter;
    private Component initialFocusOwner;
    private boolean initialFocusVisible = true;
    private boolean focusTransferred;
    private boolean defaultBindingsSet;
    private int preferredWidth;
    private double aspectRatio;

    protected AbstractStyledPane(MessageType messageType, JComponent content, Object ... commitObjects) {
        StyleManager.getStyle();
        this.visualConfiguration = this.createVisualConfiguration();
        this.setMessageType(messageType);
        this.setContent(content);
        this.setCommitCommands(commitObjects);
        this.setLayoutType(LayoutType.DEFAULT);
        this.addPropertyChangeListener(PROPERTY_COMMIT_VALUE, this::onCommitValueChange);
        this.setCloseHandler(JSDLCoreSetup.getDefaultCloseHandler());
        this.addHierarchyListener(this::onHierarchyChanged);
    }

    public final JDialog createDialog(String title) {
        return this.createDialog((Component)null, title, true);
    }

    public final JDialog createDialog(String title, boolean modal) {
        return this.createDialog((Component)null, title, modal);
    }

    public final JDialog createDialog(String title, Dialog.ModalityType type) {
        return this.createDialog((Component)null, title, type);
    }

    public final JDialog createDialog(EventObject evt, String title) {
        return this.createDialog(evt, title, true);
    }

    public final JDialog createDialog(EventObject evt, String title, boolean modal) {
        return this.createDialog((Component)AncestorSupport.getWindowFor(evt), title, modal);
    }

    public final JDialog createDialog(EventObject evt, String title, Dialog.ModalityType type) {
        return this.createDialog((Component)AncestorSupport.getWindowFor(evt), title, type);
    }

    public final JDialog createDialog(Component ownerComponent, String title) {
        return this.createDialog(ownerComponent, title, true);
    }

    public final JDialog createDialog(Component ownerComponent, String title, boolean modal) {
        Dialog.ModalityType type = modal ? Dialog.DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS;
        return this.createDialog(ownerComponent, title, type);
    }

    public final JDialog createDialog(Component ownerComponent, String title, Dialog.ModalityType type) {
        Preconditions.checkState(EventQueue.isDispatchThread(), "You must create and show dialogs from the Event-Dispatch-Thread (EDT).");
        JSDLCoreStyleChecker.getInstance().checkWindowParentNotNull(ownerComponent);
        this.checkWindowTitle(title);
        Window ownerWindow = JSDLUtils.getWindowFor(ownerComponent);
        if (this.dialog != null && this.dialog.getParent() == ownerWindow) {
            this.dialog.setTitle(title);
            this.dialog.setModalityType(type);
            return this.dialog;
        }
        this.dialog = new JSDLDialog(this, ownerWindow, title, type);
        this.initDialog(this.getMessageType().windowDecorationStyle());
        Component parent = ownerComponent != null ? ownerComponent : ownerWindow;
        this.dialog.setLocationRelativeTo(parent);
        return this.dialog;
    }

    public final void showDialog(String title) {
        this.createDialog(title).setVisible(true);
    }

    public final void showDialog(String title, boolean modal) {
        this.createDialog(title, modal).setVisible(true);
    }

    public final void showDialog(String title, Dialog.ModalityType type) {
        this.createDialog(title, type).setVisible(true);
    }

    public final void showDialog(EventObject e, String title) {
        this.createDialog(e, title).setVisible(true);
    }

    public final void showDialog(EventObject e, String title, boolean modal) {
        this.createDialog(e, title, modal).setVisible(true);
    }

    public final void showDialog(EventObject e, String title, Dialog.ModalityType type) {
        this.createDialog(e, title, type).setVisible(true);
    }

    public final void showDialog(Component parentComponent, String title) {
        this.createDialog(parentComponent, title).setVisible(true);
    }

    public final void showDialog(Component parentComponent, String title, boolean modal) {
        this.createDialog(parentComponent, title, modal).setVisible(true);
    }

    public final void showDialog(Component parentComponent, String title, Dialog.ModalityType type) {
        this.createDialog(parentComponent, title, type).setVisible(true);
    }

    public final MessageType getMessageType() {
        return this.messageType;
    }

    protected void setMessageType(MessageType newType) {
        MessageType oldType = this.getMessageType();
        this.messageType = newType;
        this.firePropertyChange(PROPERTY_MESSAGE_TYPE, (Object)oldType, (Object)newType);
    }

    public final JComponent getContent() {
        return this.content;
    }

    protected void setContent(JComponent newContent) {
        JComponent oldContent = this.getContent();
        this.content = newContent;
        this.firePropertyChange(PROPERTY_CONTENT, oldContent, newContent);
    }

    public final JComponent getCommandBar() {
        return this.commandBar;
    }

    public final void setCommandBar(JComponent newCommandBar) {
        JComponent oldCommandBar = this.getCommandBar();
        if (oldCommandBar != null) {
            // empty if block
        }
        this.commandBar = newCommandBar;
        if (newCommandBar != null) {
            // empty if block
        }
        this.firePropertyChange(PROPERTY_COMMAND_BAR, oldCommandBar, newCommandBar);
    }

    public final boolean isCommandContentVisible() {
        return ((AbstractStyledPaneVisualConfiguration)this.getVisualConfiguration()).isCommandContentVisible();
    }

    protected void setCommandContentVisible(boolean newValue) {
        ((AbstractStyledPaneVisualConfiguration)this.getVisualConfiguration()).setCommandContentVisible(newValue);
    }

    protected void setCommitCommands(Object ... commitObjects) {
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        this.cancelObject = null;
        this.commitMap.clear();
        JButton[] buttons = new JButton[commitObjects.length];
        for (int i = 0; i < commitObjects.length; ++i) {
            Object commitObject = commitObjects[i];
            Preconditions.checkNotNull(commitObject, "The commit objects must be non-null.");
            if (commitObject instanceof JButton) {
                buttons[i] = (JButton)commitObject;
            } else {
                Action commitAction;
                if (commitObject instanceof Component) {
                    throw new IllegalArgumentException("The commit objects must not be components other than JButton.\nInstead use #setCommitButtons(JButton...) or #setCommitBar(JComponent).");
                }
                if (commitObject instanceof Action) {
                    commitAction = (Action)commitObject;
                } else if (commitObject instanceof CommandValue) {
                    commitAction = new CommandValueCommitAction((CommandValue)commitObject);
                } else {
                    String buttonText = commitObject.toString().trim();
                    commitAction = new CommandValueCommitAction(commitObject, buttonText);
                }
                buttons[i] = factory.createButton(commitAction);
            }
            this.commitMap.put(commitObject, buttons[i]);
            if (commitObject != CommandValue.CANCEL && commitObject != CommandValue.CLOSE) continue;
            this.setCancelCommand0(commitObject);
        }
        this.setCommitButtons(buttons);
    }

    protected void setAdditionalCommands(Action ... commandActions) {
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        JButton[] buttons = new JButton[commandActions.length];
        for (int i = 0; i < commandActions.length; ++i) {
            Action commandObject = commandActions[i];
            Preconditions.checkNotNull(commandObject, "The command objects must be non-null.");
            buttons[i] = factory.createButton(commandObject);
        }
        this.setAdditionalCommandButtons(buttons);
    }

    protected void setAdditionalCommandButtons(JButton ... commandButtons) {
        Preconditions.checkArgument(commandButtons != null && commandButtons.length > 0, "At least one command button must be provided.");
        this.additionalCommandButtons = commandButtons;
        this.updateCommandBar();
    }

    protected void setDefaultCommand(Object buttonOrActionOrCommandValue) {
        this.defaultButton = null;
        if (buttonOrActionOrCommandValue == null) {
            this.setDefaultButton(null);
            return;
        }
        for (JButton button : this.commandButtons()) {
            Object commitObject;
            if (button == buttonOrActionOrCommandValue) {
                this.defaultButton = button;
                break;
            }
            Action action = button.getAction();
            if (action == buttonOrActionOrCommandValue) {
                this.defaultButton = button;
                break;
            }
            if (!(action instanceof CommandValueCommitAction) || !(commitObject = ((CommandValueCommitAction)action).getCommitValue()).equals(buttonOrActionOrCommandValue)) continue;
            this.defaultButton = button;
            break;
        }
        if (this.defaultButton != null) {
            this.setDefaultButton(this.defaultButton);
            return;
        }
        throw new IllegalArgumentException("Couldn't find the default button or object:" + buttonOrActionOrCommandValue);
    }

    protected void setDefaultCommandIndex(int index) {
        this.defaultButton = this.commandButtons().get(index);
    }

    protected void setCancelCommand(Object cancelObject) {
        this.setCancelCommand0(cancelObject);
        this.updateCommandBar();
    }

    public final boolean isCancelAllowed() {
        return this.cancelAllowed;
    }

    public final void setCancelAllowed(boolean newValue) {
        boolean oldValue = this.isCancelAllowed();
        this.cancelAllowed = newValue;
        this.firePropertyChange(PROPERTY_CANCEL_ALLOWED, oldValue, newValue);
    }

    public final Object getCommitValue() {
        return this.value;
    }

    public final void setCommitValue(Object newValue) {
        Object oldValue = this.getCommitValue();
        this.value = newValue;
        this.firePropertyChange(PROPERTY_COMMIT_VALUE, oldValue, newValue);
    }

    public final boolean isCancelled() {
        return this.getCommitValue() == this.cancelObject || this.getCommitValue() == CommandValue.CANCEL;
    }

    public final CloseHandler getCloseHandler() {
        return this.closeHandler;
    }

    public final void setCloseHandler(CloseHandler closeHandler) {
        this.closeHandler = closeHandler;
    }

    public final void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            return;
        }
        Preconditions.checkState(this.getCloseHandler() != null, "A CloseHandler must be set if a styled pane is closed that has no associated dialog. See JSDLSetup#setDefaultCloseHandler and AbstractStylePane#setCloseHandler.");
        this.getCloseHandler().closePane(this);
    }

    protected CloseRequestHandler getCloseRequestHandler() {
        return this.closeRequestHandler;
    }

    protected void setCloseRequestHandler(CloseRequestHandler closeRequestHandler) {
        this.closeRequestHandler = closeRequestHandler;
    }

    @Override
    public void onPaneClosing(EventObject evt, Runnable postOperation) {
        Preconditions.checkNotNull(postOperation, "The post operation must not be null. Use CloseRequestHandler.NO_OPERATION instead.");
        if (this.getCloseRequestHandler() != null) {
            this.getCloseRequestHandler().onPaneClosing(evt, postOperation);
            return;
        }
        if (this.cancelObject != null) {
            this.performCancel();
            postOperation.run();
            return;
        }
        if (this.isCancelAllowed()) {
            this.setCommitValue(CommandValue.CANCEL);
            postOperation.run();
            return;
        }
        this.rejectPaneClosing(evt);
    }

    protected void windowClosing(EventObject evt) {
        if (this.cancelObject != null) {
            this.performCancel();
        } else if (this.isCancelAllowed()) {
            this.setCommitValue(CommandValue.CANCEL);
        } else {
            this.rejectWindowClosing(evt);
        }
    }

    protected void performCancel() {
        if (this.cancelObject instanceof Action) {
            Action cancelAction = (Action)this.cancelObject;
            cancelAction.actionPerformed(new ActionEvent(this, 1001, "cancel"));
        } else if (this.cancelObject instanceof JButton) {
            ((JButton)this.cancelObject).doClick();
        } else {
            this.setCommitValue(this.cancelObject);
        }
    }

    protected void rejectPaneClosing(EventObject evt) {
        ((TaskPaneBuilder)((TaskPaneBuilder)((TaskPaneBuilder)new TaskPaneBuilder().owner(evt)).title(CoreDialogResources.getString("dialogs.rejectPaneClosing.title"), new Object[0])).mainInstructionText(CoreDialogResources.getString("dialogs.rejectPaneClosing.mainInstruction"), new Object[0]).contentText(CoreDialogResources.getString("dialogs.rejectPaneClosing.supplementalInstruction"), new Object[0]).commitCommands(CommandValue.CLOSE).preferredWidth(PreferredWidth.MEDIUM)).showDialog();
    }

    protected void rejectWindowClosing(EventObject evt) {
        ((TaskPaneBuilder)((TaskPaneBuilder)((TaskPaneBuilder)new TaskPaneBuilder().owner(evt)).title(CoreDialogResources.getString("dialogs.rejectWindowClosing.title"), new Object[0])).mainInstructionText(CoreDialogResources.getString("dialogs.rejectWindowClosing.mainInstruction"), new Object[0]).contentText(CoreDialogResources.getString("dialogs.rejectWindowClosing.supplementalInstruction"), new Object[0]).commitCommands(CommandValue.CLOSE).preferredWidth(PreferredWidth.MEDIUM)).showDialog();
    }

    public Component getInitialFocusOwner() {
        return this.initialFocusOwner;
    }

    public final void setInitialFocusOwner(Component c) {
        this.initialFocusOwner = c;
    }

    public final boolean isInitialFocusVisible() {
        return this.initialFocusVisible;
    }

    public final void setInitialFocusVisible(boolean newValue) {
        boolean oldValue = this.isInitialFocusVisible();
        this.initialFocusVisible = newValue;
        this.firePropertyChange(PROPERTY_INITIAL_FOCUS_VISIBLE, oldValue, newValue);
    }

    public final boolean isInitialFocusRequested() {
        return !Boolean.FALSE.equals(this.getClientProperty(PROPERTY_INITIAL_FOCUS_REQUESTED));
    }

    public final void setInitialFocusRequested(boolean newValue) {
        this.putClientProperty(PROPERTY_INITIAL_FOCUS_REQUESTED, newValue);
    }

    public final HyperlinkListener getHyperlinkListener() {
        return this.hyperlinkListener;
    }

    public final void setHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.hyperlinkListener = hyperlinkListener;
    }

    public final int getPreferredWidth() {
        return this.preferredWidth;
    }

    public final void setPreferredWidth(int customValue) {
        Preconditions.checkArgument(customValue >= 0, "The preferred width must be positive, or 0 to disable the feature.");
        int oldWidth = this.getPreferredWidth();
        this.preferredWidth = customValue;
        this.firePropertyChange(PROPERTY_PREFERRED_WIDTH, oldWidth, customValue);
    }

    public final void setPreferredWidth(PreferredWidth standardizedValue) {
        Preconditions.checkNotNull(standardizedValue, "The standardized width must not be null; use NONE to pack a created dialog.");
        this.setPreferredWidth(standardizedValue.value());
    }

    public final double getAspectRatio() {
        return this.aspectRatio;
    }

    public final void setAspectRatio(double customValue) {
        Preconditions.checkArgument(customValue >= 0.0, "The aspect ratio must positive, or 0 to disable the feature.");
        double oldValue = this.getAspectRatio();
        this.aspectRatio = customValue;
        this.firePropertyChange(PROPERTY_ASPECT_RATIO, oldValue, customValue);
    }

    public final void setAspectRatio(AspectRatio standardizedValue) {
        Preconditions.checkNotNull(standardizedValue, "The standardized aspect ratio must not be null; use NONE to disable this feature.");
        this.setAspectRatio(standardizedValue.value());
    }

    public final VC getVisualConfiguration() {
        return this.visualConfiguration;
    }

    protected VC createVisualConfiguration() {
        return (VC)new AbstractStyledPaneVisualConfiguration(this);
    }

    protected abstract String layoutGroup();

    public final void setLayoutType(LayoutType layoutType) {
        ((AbstractStyledPaneVisualConfiguration)this.getVisualConfiguration()).setLayoutType(layoutType);
    }

    public final void setUI(StyledPaneUI ui) {
        if ((StyledPaneUI)this.ui != ui) {
            super.setUI(ui);
            this.invalidate();
        }
    }

    @Override
    public final StyledPaneUI getUI() {
        return (StyledPaneUI)this.ui;
    }

    @Override
    public void updateUI() {
        this.setUI((StyledPaneUI)UIManager.getUI(this));
    }

    protected List<JButton> commandButtons() {
        ArrayList<JButton> buttons = new ArrayList<JButton>(Arrays.asList(this.commitButtons));
        if (this.additionalCommandButtons != null) {
            buttons.addAll(Arrays.asList(this.additionalCommandButtons));
        }
        return buttons;
    }

    protected final void setDefaultButton(JButton button) {
        JRootPane root = this.getRootPane();
        if (root != null) {
            root.setDefaultButton(button);
        }
    }

    protected final void registerCancelOnEscapeKey() {
        ComponentUtils.registerKeyboardAction(this, new WindowCancellingAction(), KeyStroke.getKeyStroke(27, 0), 1);
    }

    protected void setCommitButtons(JButton ... commitButtons) {
        JSDLCoreStyleChecker.getInstance().checkCommitButtonsNotEmpty(commitButtons);
        this.commitButtons = commitButtons;
        boolean empty = commitButtons == null || commitButtons.length == 0;
        this.defaultButton = empty ? null : commitButtons[0];
        this.updateCommandBar();
    }

    protected final void updateCommandBar() {
        this.setCommandBar(this.buildDefaultCommandBar());
    }

    protected JComponent buildDefaultCommandBar() {
        this.checkValidButtons();
        return new CommandBarBuilder().buttons(this.commitButtons, this.additionalCommandButtons, this.getButtonFor(this.cancelObject)).build();
    }

    protected void checkValidButtons() {
        JSDLCoreStyleChecker checker = JSDLCoreStyleChecker.getInstance();
        checker.checkButtonTextsNotBlank(this.additionalCommandButtons);
        checker.checkButtonTextsNotBlank(this.commitButtons);
        HashSet<String> texts = new HashSet<String>();
        checker.checkButtonTextsAreUnique(texts, this.additionalCommandButtons);
        checker.checkButtonTextsAreUnique(texts, this.commitButtons);
        checker.checkErrorsAreNeverOK(this.getMessageType(), this.commitButtons);
        checker.checkButtonTextSpelling(this.additionalCommandButtons);
        checker.checkButtonTextSpelling(this.commitButtons);
        checker.checkAdditionalButtonIsNotCommit(this.additionalCommandButtons);
        checker.checkCommitButtonOrder(this.commitButtons);
    }

    protected void checkWindowTitle(String title) {
        JSDLCoreStyleChecker.getInstance().checkWindowTitle(title);
    }

    private void initDialog(int windowDecorationStyle) {
        this.dialog.setComponentOrientation(this.getComponentOrientation());
        this.dialog.setContentPane(this);
        this.dialog.setResizable(true);
        this.dialog.setDefaultCloseOperation(0);
        if (JDialog.isDefaultLookAndFeelDecorated() && UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
            this.dialog.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(windowDecorationStyle);
        }
        this.computeAndSetInitialDialogSize();
        this.setDialogAspectRatio();
        this.windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                AbstractStyledPane.this.windowClosing(we);
            }
        };
        this.dialog.addWindowListener(this.windowAdapter);
        this.componentAdapter = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                AbstractStyledPane.this.setCommitValue(UNINITIALIZED_VALUE);
            }
        };
        this.dialog.addComponentListener(this.componentAdapter);
    }

    protected void computeAndSetInitialDialogSize() {
        if (this.getPreferredWidth() <= 0) {
            this.dialog.pack();
            return;
        }
        this.dialog.addNotify();
        int targetWidth = Sizes.dialogUnitXAsPixel(this.getPreferredWidth(), this.dialog);
        this.dialog.setSize(targetWidth, Integer.MAX_VALUE);
        this.dialog.validate();
        this.invalidateComponentTree(this);
        Dimension dialogPrefSize = this.dialog.getPreferredSize();
        int targetHeight = dialogPrefSize.height;
        this.dialog.setSize(targetWidth, targetHeight);
    }

    protected void setDialogAspectRatio() {
        int targetHeight;
        Dimension size;
        if (this.getAspectRatio() == AspectRatio.NONE.value()) {
            return;
        }
        do {
            size = this.dialog.getSize();
            targetHeight = (int)Math.round((double)size.width / this.getAspectRatio());
            if (size.height == targetHeight) {
                return;
            }
            if (size.height < targetHeight) {
                this.dialog.setSize(size.width, targetHeight);
                return;
            }
            this.dialog.setSize(size.width + 25, size.height);
            this.dialog.validate();
            this.invalidateComponentTree(this);
            Dimension dialogPrefSize = this.dialog.getPreferredSize();
            int newPrefHeight = dialogPrefSize.height;
            this.dialog.setSize(this.dialog.getSize().width, newPrefHeight);
        } while (size.height > targetHeight);
    }

    private void setCancelCommand0(Object cancelObject) {
        JButton cancelButton;
        if (cancelObject instanceof JButton) {
            cancelButton = (JButton)cancelObject;
            Preconditions.checkArgument(Arrays.asList(this.commitButtons).contains(cancelButton), "A JButton cancel object must be one of the buttons in #setCommitButtons(Object...).");
        } else {
            if (cancelObject instanceof Component) {
                throw new IllegalArgumentException("The cancel object must be an Object, CommandValue, Action, or JButton.");
            }
            cancelButton = this.getButtonFor(cancelObject);
            Preconditions.checkArgument(cancelButton != null, "The cancel object must be a JButton or one of the commit objects set during construction or in #setCommitCommands(Object...).");
        }
        this.cancelObject = cancelObject;
        cancelButton.setVerifyInputWhenFocusTarget(false);
    }

    protected final JButton getButtonFor(Object commitObject) {
        return this.commitMap.get(commitObject);
    }

    private void invalidateComponentTree(Component c) {
        if (c instanceof Container) {
            Container container = (Container)c;
            for (Component child : container.getComponents()) {
                this.invalidateComponentTree(child);
            }
            container.invalidate();
        }
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    private void onCommitValueChange(PropertyChangeEvent event) {
        if (event.getSource() == this && event.getNewValue() != UNINITIALIZED_VALUE) {
            this.close();
        }
    }

    private void onHierarchyChanged(HierarchyEvent evt) {
        if (evt.getID() != 1400) {
            return;
        }
        if ((evt.getChangeFlags() & 2L) != 0L && evt.getChanged().isDisplayable() && !this.defaultBindingsSet) {
            this.setDefaultBindings();
        }
        if ((evt.getChangeFlags() & 4L) != 0L && evt.getChanged().isShowing() && !this.focusTransferred && this.isInitialFocusRequested()) {
            EventQueue.invokeLater(this::requestFocusToMe);
        }
    }

    private void setDefaultBindings() {
        this.defaultBindingsSet = true;
        this.setDefaultButton(this.defaultButton);
        this.registerCancelOnEscapeKey();
    }

    private void requestFocusToMe() {
        this.focusTransferred = true;
        AbstractStyledPane me = this;
        if (!this.isInitialFocusVisible() && !JSDLCommonSetup.isOptimizedForScreenReader()) {
            me.requestFocusInWindow();
            return;
        }
        if (this.getInitialFocusOwner() != null) {
            this.getInitialFocusOwner().requestFocusInWindow();
            return;
        }
        JSDLUtils.transferFocusToDefaultOwner(this, this.commandButtons(), this.defaultButton);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = this.createAccessibleContext();
        }
        return this.accessibleContext;
    }

    protected AccessibleContext createAccessibleContext() {
        return new AccessibleStyledPane();
    }

    protected AccessibleRole getAccessibleRole() {
        return AccessibleRole.PANEL;
    }

    static {
        StyleManager.getStyle();
    }

    protected class AccessibleStyledPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleStyledPane() {
            super(AbstractStyledPane.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AbstractStyledPane.this.getAccessibleRole();
        }
    }

    private static class JSDLDialog
    extends JDialog {
        private final AbstractStyledPane<?> pane;

        JSDLDialog(AbstractStyledPane<?> pane, Window owner, String title, Dialog.ModalityType type) {
            super(owner, title, type);
            this.pane = pane;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJSDLDialog();
            }
            return this.accessibleContext;
        }

        protected final class AccessibleJSDLDialog
        extends JDialog.AccessibleJDialog {
            protected AccessibleJSDLDialog() {
                super(JSDLDialog.this);
            }

            @Override
            public String getAccessibleName() {
                if (this.accessibleName != null) {
                    return this.accessibleName;
                }
                String name = super.getAccessibleName();
                MessageType type = JSDLDialog.this.pane.getMessageType();
                if (type == MessageType.ERROR || type == MessageType.WARNING || type == MessageType.QUESTION_CRITICAL) {
                    name = type.getDescription() + ": " + name;
                }
                return name;
            }
        }
    }

    private final class WindowCancellingAction
    extends AbstractAction {
        private WindowCancellingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractStyledPane.this.windowClosing(e);
        }
    }
}

