/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.dialogs.core.LayoutType;
import com.jgoodies.dialogs.core.pane.AbstractStyledPane;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class AbstractStyledPaneVisualConfiguration {
    public static final String PROPERTY_HEADER_AREA = "headerArea";
    public static final String PROPERTY_CONTENT_AREA = "contentArea";
    public static final String PROPERTY_COMMAND_AREA = "commandArea";
    public static final String PROPERTY_HEADER_FONT = "headerFont";
    public static final String PROPERTY_HEADER_FOREGROUND = "headerForeground";
    public static final String PROPERTY_MARGIN_DIALOG_LEFT = "marginDialogLeft";
    public static final String PROPERTY_MARGIN_DIALOG_RIGHT = "marginDialogRight";
    public static final String PROPERTY_MARGIN_HEADER_TOP = "marginHeaderTop";
    public static final String PROPERTY_MARGIN_HEADER_BOTTOM = "marginHeaderBottom";
    public static final String PROPERTY_MARGIN_CONTENT_TOP = "marginContentTop";
    public static final String PROPERTY_MARGIN_CONTENT_BOTTOM = "marginContentBottom";
    public static final String PROPERTY_MIN_HEIGHT_COMMAND_AREA = "minHeightCommandArea";
    public static final String PROPERTY_CONTENT_ALIGNMENT_LEFT = "contentAlignmentLeft";
    public static final String PROPERTY_CONTENT_ALIGNMENT_RIGHT = "contentAlignmentRight";
    public static final String PROPERTY_COMMAND_CONTENT_VISIBLE = "commandContentVisible";
    private final AbstractStyledPane<?> pane;
    private JComponent headerArea;
    private JComponent contentArea;
    private JComponent commandArea;
    private Font headerFont;
    private Color headerForeground;
    private int marginDialogLeft;
    private int marginDialogRight;
    private int marginHeaderTop;
    private int marginHeaderBottom;
    private int marginContentTop;
    private int marginContentBottom;
    private int minHeightCommandArea;
    private ContentAlignmentLeft contentAlignmentLeft = ContentAlignmentLeft.MAIN_INSTRUCTION;
    private ContentAlignmentRight contentAlignmentRight = ContentAlignmentRight.MAIN_INSTRUCTION;
    private boolean commandContentVisible = true;

    protected AbstractStyledPaneVisualConfiguration(AbstractStyledPane<?> pane) {
        this.pane = Preconditions.checkNotNull(pane, "The %s must not be null.", "pane");
    }

    public final JComponent getHeaderArea() {
        return this.headerArea;
    }

    public final void setHeaderArea(JComponent newValue) {
        this.headerArea = newValue;
        this.firePropertyChange(PROPERTY_HEADER_AREA, this.getHeaderArea(), this.headerArea);
    }

    public final JComponent getContentArea() {
        return this.contentArea;
    }

    public final void setContentArea(JComponent newValue) {
        this.contentArea = newValue;
        this.firePropertyChange(PROPERTY_CONTENT_AREA, this.getContentArea(), this.contentArea);
    }

    public final JComponent getCommandArea() {
        return this.commandArea;
    }

    public final void setCommandArea(JComponent newValue) {
        this.commandArea = newValue;
        this.firePropertyChange(PROPERTY_COMMAND_AREA, this.getCommandArea(), this.commandArea);
    }

    public final Font getHeaderFont() {
        return this.headerFont;
    }

    public final void setHeaderFont(Font newValue) {
        this.headerFont = newValue;
        this.firePropertyChange(PROPERTY_HEADER_FONT, this.getHeaderFont(), this.headerFont);
    }

    public final Color getHeaderForeground() {
        return this.headerForeground;
    }

    public final void setHeaderForeground(Color newValue) {
        this.headerForeground = newValue;
        this.firePropertyChange(PROPERTY_HEADER_FOREGROUND, this.getHeaderForeground(), this.headerForeground);
    }

    public final ContentAlignmentLeft getContentAlignmentLeft() {
        return this.contentAlignmentLeft;
    }

    public final void setContentAlignmentLeft(ContentAlignmentLeft newValue) {
        Preconditions.checkNotNull(newValue, "The %s must not be null.", "content alignment left");
        this.contentAlignmentLeft = newValue;
        this.firePropertyChange(PROPERTY_CONTENT_ALIGNMENT_LEFT, (Object)this.getContentAlignmentLeft(), (Object)this.contentAlignmentLeft);
    }

    public final ContentAlignmentRight getContentAlignmentRight() {
        return this.contentAlignmentRight;
    }

    public final void setContentAlignmentRight(ContentAlignmentRight newValue) {
        Preconditions.checkNotNull(newValue, "The %s must not be null.", "content alignment right");
        this.contentAlignmentRight = newValue;
        this.firePropertyChange(PROPERTY_CONTENT_ALIGNMENT_RIGHT, (Object)this.getContentAlignmentRight(), (Object)this.contentAlignmentRight);
    }

    public final boolean isCommandContentVisible() {
        return this.commandContentVisible;
    }

    protected void setCommandContentVisible(boolean newValue) {
        this.commandContentVisible = newValue;
        this.firePropertyChange(PROPERTY_COMMAND_CONTENT_VISIBLE, this.isCommandContentVisible(), this.commandContentVisible);
    }

    public final int getMarginHeaderTop() {
        return this.marginHeaderTop;
    }

    public final void setMarginHeaderTop(int dlu) {
        this.marginHeaderTop = dlu;
        this.firePropertyChange(PROPERTY_MARGIN_HEADER_TOP, this.getMarginHeaderTop(), this.marginHeaderTop);
    }

    public final int getMarginHeaderBottom() {
        return this.marginHeaderBottom;
    }

    public final void setMarginHeaderBottom(int dlu) {
        this.marginHeaderBottom = dlu;
        this.firePropertyChange(PROPERTY_MARGIN_HEADER_BOTTOM, this.getMarginHeaderBottom(), this.marginHeaderBottom);
    }

    public final int getMarginDialogLeft() {
        return this.marginDialogLeft;
    }

    public final void setMarginDialogLeft(int dlu) {
        this.marginDialogLeft = dlu;
        this.firePropertyChange(PROPERTY_MARGIN_DIALOG_LEFT, this.getMarginDialogLeft(), this.marginDialogLeft);
    }

    public final int getMarginDialogRight() {
        return this.marginDialogRight;
    }

    public final void setMarginDialogRight(int dlu) {
        this.marginDialogRight = dlu;
        this.firePropertyChange(PROPERTY_MARGIN_DIALOG_RIGHT, this.getMarginDialogRight(), this.marginDialogRight);
    }

    public final int getMarginContentTop() {
        return this.marginContentTop;
    }

    public final void setMarginContentTop(int dlu) {
        this.marginContentTop = dlu;
        this.firePropertyChange(PROPERTY_MARGIN_CONTENT_TOP, this.getMarginContentTop(), this.marginContentTop);
    }

    public final int getMarginContentBottom() {
        return this.marginContentBottom;
    }

    public final void setMarginContentBottom(int dlu) {
        this.marginContentBottom = dlu;
        this.firePropertyChange(PROPERTY_MARGIN_CONTENT_BOTTOM, this.getMarginContentBottom(), this.marginContentBottom);
    }

    public final int getMinHeightCommandArea() {
        return this.minHeightCommandArea;
    }

    public final void setMinHeightCommandArea(int dlu) {
        this.minHeightCommandArea = dlu;
        this.firePropertyChange(PROPERTY_MIN_HEIGHT_COMMAND_AREA, this.getMinHeightCommandArea(), this.minHeightCommandArea);
    }

    public final void setLayoutType(LayoutType layoutType) {
        Preconditions.checkNotNull(layoutType, "The %s must not be null.", "layout type");
        this.configureLayout(this.layoutPrefix(layoutType));
    }

    protected void configureLayout(String prefix) {
        this.setMarginDialogLeft(UIManager.getInt(prefix + "margin.pane.left"));
        this.setMarginDialogRight(UIManager.getInt(prefix + "margin.pane.right"));
        this.setMarginHeaderTop(UIManager.getInt(prefix + "margin.header.top"));
        this.setMarginHeaderBottom(UIManager.getInt(prefix + "margin.header.bottom"));
        this.setMarginContentTop(UIManager.getInt(prefix + "margin.content.top"));
        this.setMarginContentBottom(UIManager.getInt(prefix + "margin.content.bottom"));
        this.setMinHeightCommandArea(UIManager.getInt(prefix + "commandArea.minHeight"));
    }

    private String layoutPrefix(LayoutType layoutType) {
        return this.pane.layoutGroup() + '.' + layoutType.getPrefix() + '.';
    }

    protected final void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.pane.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pane.firePropertyChange(propertyName, oldValue, newValue);
    }

    public static enum ContentAlignmentLeft {
        BORDER,
        MAIN_ICON,
        MAIN_INSTRUCTION;

    }

    public static enum ContentAlignmentRight {
        BORDER,
        MAIN_INSTRUCTION;

    }
}

