/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.reference.PatternMatchingReference;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class CskillLst
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject>,
ChooseSelectionActor<Skill> {
    private static final Class<Skill> SKILL_CLASS = Skill.class;
    private static final String SOURCE = "CSKILLLST";

    public String getTokenName() {
        return "CSKILL";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        boolean first = true;
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            String tokText = tok.nextToken();
            if (".CLEAR".equals(tokText)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item", context);
                }
                context.getObjectContext().removeList(obj, ListKey.CSKILL);
            } else if (tokText.startsWith(".CLEAR.")) {
                String clearText = tokText.substring(7);
                if ("ALL".equals(clearText)) {
                    context.getObjectContext().removeFromList(obj, ListKey.CSKILL, (Object)context.getReferenceContext().getCDOMAllReference(SKILL_CLASS));
                } else if ("LIST".equals(clearText)) {
                    context.getObjectContext().removeFromList(obj, ListKey.NEW_CHOOSE_ACTOR, (Object)this);
                } else {
                    CDOMReference ref = TokenUtilities.getTypeOrPrimitive((LoadContext)context, SKILL_CLASS, (String)clearText);
                    if (ref == null) {
                        return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                    }
                    context.getObjectContext().removeFromList(obj, ListKey.CSKILL, (Object)ref);
                }
            } else if ("ALL".equals(tokText)) {
                foundAny = true;
                context.getObjectContext().addToList(obj, ListKey.CSKILL, (Object)context.getReferenceContext().getCDOMAllReference(SKILL_CLASS));
            } else {
                foundOther = true;
                if ("LIST".equals(tokText)) {
                    context.getObjectContext().addToList(obj, ListKey.NEW_CHOOSE_ACTOR, (Object)this);
                } else {
                    CDOMReference<Skill> ref = this.getSkillReference(context, tokText);
                    if (ref == null) {
                        return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                    }
                    context.getObjectContext().addToList(obj, ListKey.CSKILL, ref);
                }
            }
            first = false;
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    private CDOMReference<Skill> getSkillReference(LoadContext context, String tokText) {
        if (tokText.endsWith("%")) {
            return new PatternMatchingReference(Skill.class, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS), tokText);
        }
        return TokenUtilities.getTypeOrPrimitive((LoadContext)context, SKILL_CLASS, (String)tokText);
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Collection listAdded;
        Collection added;
        Collection listRemoved;
        Changes changes = context.getObjectContext().getListChanges(obj, ListKey.CSKILL);
        Changes listChanges = context.getObjectContext().getListChanges(obj, ListKey.NEW_CHOOSE_ACTOR);
        ArrayList<String> list = new ArrayList<String>();
        Collection removedItems = changes.getRemoved();
        if (removedItems != null && !removedItems.isEmpty()) {
            if (changes.includesGlobalClear()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR." + ReferenceUtilities.joinLstFormat((Collection)removedItems, (String)"|.CLEAR."));
        }
        if ((listRemoved = listChanges.getRemoved()) != null && !listRemoved.isEmpty() && listRemoved.contains((Object)this)) {
            list.add(".CLEAR.LIST");
        }
        if (changes.includesGlobalClear()) {
            list.add(".CLEAR");
        }
        if ((added = changes.getAdded()) != null && !added.isEmpty()) {
            list.add(ReferenceUtilities.joinLstFormat((Collection)added, (String)"|"));
        }
        if ((listAdded = listChanges.getAdded()) != null && !listAdded.isEmpty()) {
            for (ChooseSelectionActor cra : listAdded) {
                if (!cra.getSource().equals(SOURCE)) continue;
                try {
                    list.add(cra.getLstFormat());
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)e));
                    return null;
                }
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(ChooseDriver obj, Skill skill, PlayerCharacter pc) {
        pc.addGlobalCost(SkillCost.CLASS, skill, (Object)obj);
    }

    public void removeChoice(ChooseDriver obj, Skill skill, PlayerCharacter pc) {
        pc.removeGlobalCost(SkillCost.CLASS, skill, (Object)obj);
    }

    public Class<Skill> getChoiceClass() {
        return Skill.class;
    }

    public String getSource() {
        return SOURCE;
    }

    public String getLstFormat() {
        return "LIST";
    }
}

