/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.core.Equipment;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class AlttypeToken
extends AbstractNonEmptyToken<Equipment>
implements CDOMPrimaryToken<Equipment> {
    public String getTokenName() {
        return "ALTTYPE";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, Equipment eq, String value) {
        ParseResult pr;
        EquipmentHead head = eq.getEquipmentHead(2);
        if (value.startsWith(".CLEAR")) {
            context.getObjectContext().removeList((CDOMObject)head, ListKey.TYPE);
            if (value.length() == 6) {
                return ParseResult.SUCCESS;
            }
            if (value.charAt(6) == '.') {
                if (this.isEmpty(value = value.substring(7))) {
                    return new ParseResult.Fail(this.getTokenName() + "started with .CLEAR. but expected to have a Type after .: " + value, context);
                }
            } else {
                return new ParseResult.Fail(this.getTokenName() + "started with .CLEAR but expected next character to be .: " + value, context);
            }
        }
        if (!(pr = this.checkForIllegalSeparator('.', value)).passed()) {
            return pr;
        }
        StringTokenizer aTok = new StringTokenizer(value, ".");
        boolean bRemove = false;
        boolean bAdd = false;
        while (aTok.hasMoreTokens()) {
            Type type;
            String aType = aTok.nextToken();
            if ("ADD".equals(aType)) {
                if (bRemove) {
                    return new ParseResult.Fail("Non-sensical use of .REMOVE.ADD. in " + this.getTokenName() + ": " + value, context);
                }
                bRemove = false;
                bAdd = true;
                continue;
            }
            if ("REMOVE".equals(aType)) {
                if (bAdd) {
                    return new ParseResult.Fail("Non-sensical use of .ADD.REMOVE. in " + this.getTokenName() + ": " + value, context);
                }
                bRemove = true;
                continue;
            }
            if ("CLEAR".equals(aType)) {
                return new ParseResult.Fail("Non-sensical use of .CLEAR in " + this.getTokenName() + ": " + value, context);
            }
            if (bRemove) {
                type = Type.getConstant((String)aType);
                context.getObjectContext().removeFromList((CDOMObject)head, ListKey.TYPE, (Object)type);
                bRemove = false;
                continue;
            }
            type = Type.getConstant((String)aType);
            context.getObjectContext().addToList((CDOMObject)head, ListKey.TYPE, (Object)type);
            bAdd = false;
        }
        if (bRemove) {
            return new ParseResult.Fail(this.getTokenName() + "ended with REMOVE, so didn't have any Type to remove: " + value, context);
        }
        if (bAdd) {
            return new ParseResult.Fail(this.getTokenName() + "ended with ADD, so didn't have any Type to add: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Equipment eq) {
        Collection removed;
        EquipmentHead head = eq.getEquipmentHead(2);
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)head, ListKey.TYPE);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Collection added = changes.getAdded();
        boolean globalClear = changes.includesGlobalClear();
        if (globalClear) {
            sb.append(".CLEAR");
        }
        if (added != null && !added.isEmpty()) {
            if (globalClear) {
                sb.append(".");
            }
            sb.append(StringUtil.join((Collection)added, (String)"."));
        }
        if ((removed = changes.getRemoved()) != null && !removed.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append("REMOVE.");
            sb.append(StringUtil.join((Collection)removed, (String)"."));
        }
        if (sb.length() == 0) {
            context.addWriteMessage(this.getTokenName() + " was expecting non-empty changes to include " + "added items or global clear");
            return null;
        }
        return new String[]{sb.toString()};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

