/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import pcgen.base.formula.Formula;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PCClass;

public class LevelCommandFactory
extends ConcretePrereqObject
implements Comparable<LevelCommandFactory> {
    private final CDOMSingleRef<PCClass> pcClass;
    private final Formula levels;

    public LevelCommandFactory(CDOMSingleRef<PCClass> classRef, Formula lvls) {
        if (classRef == null) {
            throw new IllegalArgumentException("Class Reference for LevelCommandFactory cannot be null");
        }
        if (lvls == null) {
            throw new IllegalArgumentException("Level Formula for LevelCommandFactory cannot be null");
        }
        this.pcClass = classRef;
        this.levels = lvls;
    }

    public Formula getLevelCount() {
        return this.levels;
    }

    public PCClass getPCClass() {
        return this.pcClass.resolvesTo();
    }

    public String getLSTformat() {
        return this.pcClass.getLSTformat(false);
    }

    public int hashCode() {
        return this.pcClass.hashCode() * 29 + this.levels.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LevelCommandFactory)) {
            return false;
        }
        LevelCommandFactory lcf = (LevelCommandFactory)obj;
        return this.levels.equals(lcf.levels) && this.pcClass.equals(lcf.pcClass);
    }

    @Override
    public int compareTo(LevelCommandFactory other) {
        int compareResult = ReferenceUtilities.REFERENCE_SORTER.compare(this.pcClass, other.pcClass);
        if (compareResult == 0) {
            if (this.levels.equals(other.levels)) {
                return 0;
            }
            if (this.levels == other.levels) {
                return 0;
            }
            return this.levels.toString().compareTo(other.levels.toString());
        }
        return compareResult;
    }
}

