/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import java.math.BigDecimal;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.term.BaseEQTermEvaluator;
import pcgen.core.term.TermEvaluator;

public class EQWeightTermEvaluator
extends BaseEQTermEvaluator
implements TermEvaluator {
    public EQWeightTermEvaluator(String expressionString) {
        this.originalText = expressionString;
    }

    @Override
    public Float resolve(Equipment eq, boolean primary, PlayerCharacter pc) {
        return this.convertToFloat(this.originalText, this.evaluate(eq, primary, pc));
    }

    @Override
    public String evaluate(Equipment eq, boolean primary, PlayerCharacter pc) {
        if (eq.isCalculatingCost() && eq.isWeightAlreadyUsed()) {
            return "0";
        }
        BigDecimal weightInPounds = eq.getWeightInPounds();
        if (eq.isCalculatingCost() && eq.isAmmunition()) {
            Float unitWeight = Float.valueOf(weightInPounds.floatValue());
            unitWeight = Float.valueOf(unitWeight.floatValue() / (float)eq.getSafe(IntegerKey.BASE_QUANTITY));
            eq.setWeightAlreadyUsed(true);
            return String.valueOf(unitWeight);
        }
        eq.setWeightAlreadyUsed(true);
        return String.valueOf(weightInPounds);
    }

    @Override
    public boolean isSourceDependant() {
        return true;
    }

    public boolean isStatic() {
        return false;
    }
}

