/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import pcgen.core.Globals;
import pcgen.core.Skill;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.spell.Spell;
import pcgen.core.term.BasePCDTermEvaluator;
import pcgen.core.term.TermEvaluator;

public class PCSkillRankTermEvaluator
extends BasePCDTermEvaluator
implements TermEvaluator {
    private final String rank;

    public PCSkillRankTermEvaluator(String originalText, String rank) {
        this.originalText = originalText;
        this.rank = rank;
    }

    @Override
    public Float resolve(CharacterDisplay display) {
        return this.convertToFloat(this.originalText, this.evaluate(display));
    }

    @Override
    public String evaluate(CharacterDisplay display) {
        Skill skill = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Skill.class, this.rank);
        if (skill == null || !display.hasSkill(skill)) {
            return "0.0";
        }
        return display.getRank(skill).toString();
    }

    @Override
    public String evaluate(CharacterDisplay display, Spell aSpell) {
        return this.evaluate(display);
    }

    @Override
    public boolean isSourceDependant() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }
}

