/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.PartyFacade;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.FacadeComboBoxModel;
import pcgen.io.ExportUtilities;
import pcgen.system.BatchExporter;
import pcgen.system.CharacterManager;
import pcgen.system.ConfigurationSettings;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;

public class ExportDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final String PDF_EXPORT_DIR_PROP = "pdfExportDir";
    private static final String HTML_EXPORT_DIR_PROP = "htmlExportDir";
    private static final String PARTY_COMMAND = "PARTY";
    private static final String EXPORT_TO_COMMAND = "EXPORT_TO";
    private static final String EXPORT_COMMAND = "EXPORT";
    private static final String CLOSE_COMMAND = "CLOSE";
    private final PCGenFrame pcgenFrame;
    private final FacadeComboBoxModel<CharacterFacade> characterBoxModel;
    private final JComboBox characterBox;
    private final JCheckBox partyBox;
    private final JComboBox exportBox;
    private final JList fileList;
    private final JProgressBar progressBar;
    private final JButton exportButton;
    private final JButton closeButton;
    private final FileSearcher fileSearcher;
    private Collection<File> allTemplates = null;

    public static void showExportDialog(PCGenFrame parent) {
        ExportDialog dialog = new ExportDialog(parent);
        Utility.setDialogRelativeLocation(parent, dialog);
        dialog.setVisible(true);
    }

    private ExportDialog(PCGenFrame parent) {
        super((Frame)parent, true);
        this.pcgenFrame = parent;
        this.characterBoxModel = new FacadeComboBoxModel<CharacterFacade>(CharacterManager.getCharacters(), parent.getSelectedCharacterRef());
        this.characterBox = new JComboBox<CharacterFacade>(this.characterBoxModel);
        this.partyBox = new JCheckBox("Entire Party");
        this.exportBox = new JComboBox<SheetFilter>(SheetFilter.values());
        this.fileList = new JList();
        this.progressBar = new JProgressBar();
        this.exportButton = new JButton("Export");
        this.closeButton = new JButton("Close");
        this.fileSearcher = new FileSearcher();
        this.initComponents();
        this.initLayout();
        this.fileSearcher.execute();
        Utility.installEscapeCloseOperation(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fileSearcher.cancel(false);
        this.characterBoxModel.setReference(null);
        this.characterBoxModel.setListFacade(null);
    }

    private void initComponents() {
        this.characterBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                CharacterFacade character = (CharacterFacade)value;
                return super.getListCellRendererComponent((JList<?>)list, character.getNameRef().getReference(), index, isSelected, cellHasFocus);
            }
        });
        this.fileList.setSelectionMode(0);
        this.fileList.addListSelectionListener(this);
        this.exportButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.exportButton);
        this.partyBox.setActionCommand(PARTY_COMMAND);
        this.exportBox.setActionCommand(EXPORT_TO_COMMAND);
        this.exportButton.setActionCommand(EXPORT_COMMAND);
        this.closeButton.setActionCommand(CLOSE_COMMAND);
        this.exportBox.addActionListener(this);
        this.partyBox.addActionListener(this);
        this.exportButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.exportButton.setEnabled(false);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("Loading Templates");
        this.progressBar.setIndeterminate(true);
        this.setTitle("Export a PC or Party");
        this.setDefaultCloseOperation(2);
        UIPropertyContext context = UIPropertyContext.createContext("ExportDialog");
        String defaultOSType = context.getProperty("defaultOSType");
        if (defaultOSType != null) {
            for (SheetFilter filter : SheetFilter.values()) {
                if (!defaultOSType.equals(filter.toString())) continue;
                this.exportBox.setSelectedItem(filter);
            }
        }
    }

    private void initLayout() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        Box topPanel = Box.createHorizontalBox();
        topPanel.add(new JLabel("Select Character:"));
        topPanel.add(Box.createHorizontalStrut(5));
        topPanel.add(this.characterBox);
        topPanel.add(Box.createHorizontalStrut(5));
        topPanel.add(this.partyBox);
        topPanel.add(Box.createHorizontalGlue());
        topPanel.add(Box.createHorizontalStrut(50));
        topPanel.add(new JLabel("Export to:"));
        topPanel.add(Box.createHorizontalStrut(5));
        topPanel.add(this.exportBox);
        contentPane.add((Component)topPanel, "North");
        JScrollPane scrollPane = new JScrollPane(this.fileList);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Templates"), scrollPane.getBorder()));
        contentPane.add((Component)scrollPane, "Center");
        Box bottomPanel = Box.createHorizontalBox();
        bottomPanel.add(this.progressBar);
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(Box.createHorizontalStrut(5));
        bottomPanel.add(this.exportButton);
        bottomPanel.add(Box.createHorizontalStrut(5));
        bottomPanel.add(this.closeButton);
        contentPane.add((Component)bottomPanel, "South");
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pack();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.exportButton.setEnabled(this.fileList.getSelectedIndex() != -1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (PARTY_COMMAND.equals(e.getActionCommand())) {
            this.characterBox.setEnabled(!this.partyBox.isSelected());
            this.refreshFiles();
        } else if (EXPORT_TO_COMMAND.equals(e.getActionCommand())) {
            UIPropertyContext context = UIPropertyContext.createContext("ExportDialog");
            context.setProperty("defaultOSType", this.exportBox.getSelectedItem().toString());
            this.refreshFiles();
        } else if (EXPORT_COMMAND.equals(e.getActionCommand())) {
            this.doExport();
        } else if (CLOSE_COMMAND.equals(e.getActionCommand())) {
            this.dispose();
        }
    }

    private void doExport() {
        this.export(SheetFilter.PDF == this.exportBox.getSelectedItem());
    }

    private void setWorking(boolean working) {
        this.progressBar.setVisible(working);
        this.exportButton.setEnabled(!working);
        this.fileList.setEnabled(!working);
        this.exportBox.setEnabled(!working);
    }

    private void export(boolean pdf) {
        int reallyClose;
        String name;
        File path;
        FileNameExtensionFilter fileFilter;
        UIPropertyContext context = UIPropertyContext.createContext("ExportDialog");
        JFileChooser fcExport = new JFileChooser();
        fcExport.setFileSelectionMode(0);
        File baseDir = null;
        String path2 = pdf ? context.getProperty(PDF_EXPORT_DIR_PROP) : context.getProperty(HTML_EXPORT_DIR_PROP);
        if (path2 != null) {
            baseDir = new File(path2);
        }
        if (baseDir == null || !baseDir.isDirectory()) {
            baseDir = SystemUtils.getUserHome();
        }
        fcExport.setCurrentDirectory(baseDir);
        URI uri = (URI)this.fileList.getSelectedValue();
        String extension = ExportUtilities.getOutputExtension(uri.toString(), pdf);
        if (pdf) {
            fileFilter = new FileNameExtensionFilter("PDF Documents (*.pdf)", "pdf");
            fcExport.addChoosableFileFilter(fileFilter);
            fcExport.setFileFilter(fileFilter);
        } else if ("htm".equalsIgnoreCase(extension) || "html".equalsIgnoreCase(extension)) {
            fileFilter = new FileNameExtensionFilter("HTML Documents (*.htm, *.html)", "htm", "html");
            fcExport.addChoosableFileFilter(fileFilter);
            fcExport.setFileFilter(fileFilter);
        } else if ("xml".equalsIgnoreCase(extension)) {
            fileFilter = new FileNameExtensionFilter("XML Documents (*.xml)", "xml");
            fcExport.addChoosableFileFilter(fileFilter);
            fcExport.setFileFilter(fileFilter);
        } else {
            String desc = extension + " Files (*." + extension + ")";
            fcExport.addChoosableFileFilter(new FileNameExtensionFilter(desc, extension));
        }
        if (!this.partyBox.isSelected()) {
            CharacterFacade character = (CharacterFacade)this.characterBox.getSelectedItem();
            path = character.getFileRef().getReference();
            path = path != null ? path.getParentFile() : new File(PCGenSettings.getPcgDir());
            name = character.getTabNameRef().getReference();
            if (name == null || "".equals(name)) {
                name = character.getNameRef().getReference();
            }
        } else {
            path = new File(PCGenSettings.getPcgDir());
            name = "Entire Party";
        }
        if (pdf) {
            fcExport.setSelectedFile(new File(path, name + ".pdf"));
        } else {
            fcExport.setSelectedFile(new File(path, name + "." + extension));
        }
        fcExport.setDialogTitle("Export " + name);
        if (fcExport.showSaveDialog(this) != 0) {
            return;
        }
        File outFile = fcExport.getSelectedFile();
        if (pdf) {
            context.setProperty(PDF_EXPORT_DIR_PROP, outFile.getParent());
        } else {
            context.setProperty(HTML_EXPORT_DIR_PROP, outFile.getParent());
        }
        if (StringUtils.isEmpty(outFile.getName())) {
            this.pcgenFrame.showErrorMessage("PCGen", "You must set a filename.");
            return;
        }
        if (outFile.isDirectory()) {
            this.pcgenFrame.showErrorMessage("PCGen", "You cannot overwrite a directory with a file.");
            return;
        }
        if (outFile.exists() && !SettingsHandler.getAlwaysOverwrite() && (reallyClose = JOptionPane.showConfirmDialog(this, "The file " + outFile.getName() + " already exists, are you sure you want to overwrite it?", "Confirm overwriting " + outFile.getName(), 0)) != 0) {
            return;
        }
        try {
            if (pdf) {
                new PDFExporter(outFile, extension, name).execute();
            } else {
                if (!this.printToFile(outFile)) {
                    String message = "The character export failed. Please see the log for details.";
                    this.pcgenFrame.showErrorMessage("PCGen", message);
                    return;
                }
                this.maybeOpenFile(outFile);
                Globals.executePostExportCommandStandard(outFile.getAbsolutePath());
            }
        }
        catch (IOException ex) {
            this.pcgenFrame.showErrorMessage("PCGen", "Could not export " + name + ". Try another filename.");
            Logging.errorPrint("Could not export " + name, ex);
        }
    }

    private void maybeOpenFile(File file) {
        Object message;
        Boolean openFile;
        UIPropertyContext context = UIPropertyContext.getInstance();
        String value = context.getProperty("alwaysOpenExportFile");
        Boolean bl = openFile = StringUtils.isEmpty(value) ? null : Boolean.valueOf(value);
        if (openFile == null) {
            JCheckBox checkbox = new JCheckBox();
            checkbox.setText("Always perform this action");
            message = PCGenFrame.buildMessageLabelPanel("Do you want to open " + file.getName() + "?", checkbox);
            int ret = JOptionPane.showConfirmDialog(this, message, "Select an Option", 0, 3);
            if (ret == -1) {
                return;
            }
            openFile = BooleanUtils.toBoolean(ret, 0, 1);
            if (checkbox.isSelected()) {
                context.setBoolean("alwaysOpenExportFile", openFile);
            }
        }
        if (!openFile.booleanValue()) {
            return;
        }
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            this.pcgenFrame.showErrorMessage("Cannot Open " + file.getName(), "Operating System does not support this operation");
            return;
        }
        try {
            Desktop.getDesktop().open(file);
        }
        catch (IOException ex) {
            message = "Failed to open " + file.getName();
            this.pcgenFrame.showErrorMessage("PCGen", (String)message);
            Logging.errorPrint((String)message, ex);
        }
    }

    private File getSelectedTemplate() {
        File osDir;
        String outputSheetDirectory = SettingsHandler.getGame().getOutputSheetDirectory();
        if (outputSheetDirectory == null) {
            osDir = new File(ConfigurationSettings.getOutputSheetsDir());
            outputSheetDirectory = "";
        } else {
            osDir = new File(ConfigurationSettings.getOutputSheetsDir(), outputSheetDirectory);
        }
        URI osPath = new File(osDir, ((SheetFilter)this.exportBox.getSelectedItem()).getPath()).toURI();
        URI uri = (URI)this.fileList.getSelectedValue();
        return new File(osPath.resolve(uri));
    }

    private boolean printToFile(File outFile) throws IOException {
        File template = this.getSelectedTemplate();
        if (this.partyBox.isSelected()) {
            SettingsHandler.setSelectedPartyHTMLOutputSheet(template.getAbsolutePath());
            PartyFacade party = CharacterManager.getCharacters();
            return BatchExporter.exportPartyToNonPDF(party, outFile, template);
        }
        CharacterFacade character = (CharacterFacade)this.characterBox.getSelectedItem();
        return BatchExporter.exportCharacterToNonPDF(character, outFile, template);
    }

    private void refreshFiles() {
        if (this.allTemplates != null) {
            IOFileFilter prefixFilter;
            SheetFilter sheetFilter = (SheetFilter)this.exportBox.getSelectedItem();
            IOFileFilter ioFilter = FileFilterUtils.asFileFilter((FilenameFilter)sheetFilter);
            String defaultSheet = null;
            String outputSheetDirectory = SettingsHandler.getGame().getOutputSheetDirectory();
            String outputSheetsDir = outputSheetDirectory == null ? ConfigurationSettings.getOutputSheetsDir() + "/" + sheetFilter.getPath() : ConfigurationSettings.getOutputSheetsDir() + "/" + outputSheetDirectory + "/" + sheetFilter.getPath();
            if (this.partyBox.isSelected()) {
                prefixFilter = FileFilterUtils.prefixFileFilter((String)"psheet");
            } else {
                CharacterFacade character = (CharacterFacade)this.characterBox.getSelectedItem();
                prefixFilter = FileFilterUtils.prefixFileFilter((String)"csheet");
                defaultSheet = character.getDefaultOutputSheet(sheetFilter == SheetFilter.PDF);
                if (StringUtils.isEmpty(defaultSheet)) {
                    defaultSheet = outputSheetsDir + "/" + SettingsHandler.getGame().getOutputSheetDefault(sheetFilter.getTag());
                }
            }
            IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{prefixFilter, ioFilter});
            List files = FileFilterUtils.filterList((IOFileFilter)filter, this.allTemplates);
            Collections.sort(files);
            URI osPath = new File(outputSheetsDir).toURI();
            Object[] uriList = new Object[files.size()];
            for (int i = 0; i < uriList.length; ++i) {
                uriList[i] = osPath.relativize(((File)files.get(i)).toURI());
            }
            this.fileList.setListData(uriList);
            if (StringUtils.isNotEmpty(defaultSheet)) {
                URI defaultPath = new File(defaultSheet).toURI();
                this.fileList.setSelectedValue(osPath.relativize(defaultPath), true);
            }
        }
    }

    private static enum SheetFilter implements FilenameFilter
    {
        HTMLXML("htmlxml", "Standard", "HTM"),
        PDF("pdf", "PDF", "PDF"),
        TEXT("text", "Text", "TXT");

        private String dirFilter;
        private String description;
        private String tag;

        private SheetFilter(String dirFilter, String description, String tag) {
            this.dirFilter = dirFilter;
            this.description = description;
            this.tag = tag;
        }

        public String getPath() {
            return this.dirFilter;
        }

        public String toString() {
            return this.description;
        }

        public String getTag() {
            return this.tag;
        }

        @Override
        public boolean accept(File dir, String name) {
            return dir.getName().equalsIgnoreCase(this.dirFilter) && !name.endsWith("~");
        }
    }

    private class FileSearcher
    extends SwingWorker<Collection<File>, Object> {
        private FileSearcher() {
        }

        @Override
        protected Collection<File> doInBackground() throws Exception {
            File dir;
            String outputSheetDirectory = SettingsHandler.getGame().getOutputSheetDirectory();
            if (outputSheetDirectory == null) {
                Logging.errorPrint("OUTPUTSHEET|DIRECTORY not defined for game mode " + SettingsHandler.getGame());
                dir = new File(ConfigurationSettings.getOutputSheetsDir());
                outputSheetDirectory = "";
            } else {
                dir = new File(ConfigurationSettings.getOutputSheetsDir(), outputSheetDirectory);
                if (!dir.isDirectory()) {
                    Logging.errorPrint("Unable to find game mode outputsheets at " + dir.getCanonicalPath() + ". Trying base.");
                    dir = new File(ConfigurationSettings.getOutputSheetsDir());
                    outputSheetDirectory = "";
                }
            }
            if (!dir.isDirectory()) {
                Logging.errorPrint("Unable to find outputsheets folder at " + dir.getCanonicalPath() + ".");
                return Collections.emptyList();
            }
            IOFileFilter fileFilter = FileFilterUtils.notFileFilter((IOFileFilter)new SuffixFileFilter(".fo"));
            IOFileFilter dirFilter = FileFilterUtils.makeSVNAware((IOFileFilter)TrueFileFilter.INSTANCE);
            return FileUtils.listFiles((File)dir, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            try {
                ExportDialog.this.allTemplates = (Collection)this.get();
                ExportDialog.this.progressBar.setVisible(false);
                ExportDialog.this.refreshFiles();
            }
            catch (InterruptedException ex) {
                Logging.errorPrint("failed to search files", ex);
            }
            catch (ExecutionException ex) {
                Logging.errorPrint("failed to search files", ex.getCause());
            }
        }
    }

    private class PDFExporter
    extends SwingWorker<Object, Object> {
        private final File saveFile;
        private final String name;

        public PDFExporter(File saveFile, String extension, String name) {
            this.saveFile = saveFile;
            this.name = name;
            ExportDialog.this.progressBar.setString("Exporting to PDF");
            ExportDialog.this.setWorking(true);
        }

        @Override
        protected Object doInBackground() throws Exception {
            Boolean result = false;
            if (ExportDialog.this.partyBox.isSelected()) {
                PartyFacade party = CharacterManager.getCharacters();
                result = BatchExporter.exportPartyToPDF(party, this.saveFile, ExportDialog.this.getSelectedTemplate());
            } else {
                CharacterFacade character = (CharacterFacade)ExportDialog.this.characterBox.getSelectedItem();
                result = BatchExporter.exportCharacterToPDF(character, this.saveFile, ExportDialog.this.getSelectedTemplate());
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            boolean exception = true;
            try {
                if (!((Boolean)this.get()).booleanValue()) {
                    ExportDialog.this.pcgenFrame.showErrorMessage("Could not export " + this.name, "Error occurred while exporting. See log for details.");
                } else {
                    exception = false;
                }
            }
            catch (InterruptedException ex) {
            }
            catch (ExecutionException ex) {
                Logging.errorPrint("Could not export " + this.name, ex.getCause());
                ExportDialog.this.pcgenFrame.showErrorMessage("Could not export " + this.name, "Error occurred while exporting. See log for details.");
            }
            finally {
                if (!exception) {
                    Globals.executePostExportCommandPDF(this.saveFile.getAbsolutePath());
                }
                ExportDialog.this.setWorking(false);
                if (!exception) {
                    ExportDialog.this.maybeOpenFile(this.saveFile);
                }
            }
        }
    }
}

