/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.freemarker;

import freemarker.core.Environment;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class LoopDirective
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        int fromVal = 0;
        Integer toVal = null;
        int step = 1;
        Iterator i$ = params.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entryObj;
            Map.Entry entry = entryObj = i$.next();
            String paramName = (String)entry.getKey();
            TemplateModel paramValue = (TemplateModel)entry.getValue();
            if (paramName.equals("from")) {
                if (!(paramValue instanceof TemplateNumberModel)) {
                    throw new TemplateModelException("The \"" + paramName + "\" parameter " + "must be a number.");
                }
                fromVal = ((TemplateNumberModel)paramValue).getAsNumber().intValue();
                continue;
            }
            if (paramName.equals("to")) {
                if (!(paramValue instanceof TemplateNumberModel)) {
                    throw new TemplateModelException("The \"" + paramName + "\" parameter " + "must be a number.");
                }
                toVal = ((TemplateNumberModel)paramValue).getAsNumber().intValue();
                continue;
            }
            if (!paramName.equals("step")) continue;
            if (!(paramValue instanceof TemplateNumberModel)) {
                throw new TemplateModelException("The \"" + paramName + "\" parameter " + "must be a number.");
            }
            step = ((TemplateNumberModel)paramValue).getAsNumber().intValue();
            if (step != 0) continue;
            throw new TemplateModelException("The \"" + paramName + "\" parameter must not be 0.");
        }
        if (toVal == null) {
            throw new TemplateModelException("The \"to\" parameter must be provided.");
        }
        if (body == null) {
            throw new TemplateModelException("This directive must have content.");
        }
        if (step > 0) {
            for (int i = fromVal; i <= toVal; i += step) {
                if (loopVars.length > 0) {
                    loopVars[0] = new SimpleNumber(i);
                }
                if (loopVars.length > 1) {
                    loopVars[1] = i + step <= toVal ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
                }
                body.render(env.getOut());
            }
        } else {
            for (int i = fromVal; i >= toVal; i += step) {
                if (loopVars.length > 0) {
                    loopVars[0] = new SimpleNumber(i);
                }
                if (loopVars.length > 1) {
                    loopVars[1] = i + step >= toVal ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
                }
                body.render(env.getOut());
            }
        }
    }
}

