/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util.enumeration;

import pcgen.util.enumeration.View;

public enum Visibility {
    HIDDEN("No"),
    DEFAULT("Yes"),
    OUTPUT_ONLY("Export"),
    DISPLAY_ONLY("Display"),
    QUALIFY("Qualify");

    private final String text;

    private Visibility(String s) {
        this.text = s;
    }

    public String toString() {
        return this.text;
    }

    public String getLSTFormat() {
        return this.text.toUpperCase();
    }

    public boolean isVisibleTo(View view) {
        switch (view) {
            case ALL: {
                return true;
            }
            case HIDDEN_DISPLAY: {
                return this == HIDDEN || this == OUTPUT_ONLY;
            }
            case HIDDEN_EXPORT: {
                return this == HIDDEN || this == DISPLAY_ONLY;
            }
            case VISIBLE_EXPORT: {
                return this == DEFAULT || this == OUTPUT_ONLY;
            }
        }
        return this == DEFAULT || this == DISPLAY_ONLY;
    }
}

