/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.campaign;

import java.util.Collection;
import java.util.TreeSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Campaign;
import pcgen.core.Language;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.StringPClassUtil;

public class AllowDupesToken
extends AbstractNonEmptyToken<Campaign>
implements CDOMPrimaryToken<Campaign> {
    @Override
    public String getTokenName() {
        return "ALLOWDUPES";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, Campaign obj, String value) {
        if ("SPELL".equals(value)) {
            context.getObjectContext().addToList(obj, ListKey.DUPES_ALLOWED, Spell.class);
            return ParseResult.SUCCESS;
        }
        if ("LANGUAGE".equals(value)) {
            context.getObjectContext().addToList(obj, ListKey.DUPES_ALLOWED, Language.class);
            return ParseResult.SUCCESS;
        }
        return new ParseResult.Fail("Token must be SPELL or LANGUAGE", context);
    }

    @Override
    public String[] unparse(LoadContext context, Campaign obj) {
        Changes<Class<?>> changes = context.getObjectContext().getListChanges(obj, ListKey.DUPES_ALLOWED);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection<Class<?>> added = changes.getAdded();
        TreeSet<String> returnSet = new TreeSet<String>();
        for (Class<?> cl : added) {
            returnSet.add(StringPClassUtil.getStringFor(cl));
        }
        return returnSet.toArray(new String[returnSet.size()]);
    }

    @Override
    public Class<Campaign> getTokenClass() {
        return Campaign.class;
    }
}

