//**************************************************************************************************
//                                          Config.hpp                                             *
//                                         ------------                                            *
// Description : This class is an application specific interface to the wxWidget wxConfig object.  *
// Started     : 2016-09-25                                                                        *
// Last Update : 2020-10-31                                                                        *
// Copyright   : (C) 2016-2020 MSWaters                                                            *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

//**************************************************************************************************
// The table below list the all configuration variables :
//
//     GROUP              PARAMETER              TYPE
//    -------            -----------            ------
//     MAIN               AppVersion             wxString
//     MAIN               FrmLayout              uint
//     MAIN               TmpFileMgt             eTypeTmpFileMgt
//     MAIN               Precision              uint
//     MAIN               NbkMaxLns              uint
//     MAIN               SpnPeriod              uint
//     MAIN               ToolTipDly             uint
//     MAIN               ToolTips               bool
//     MAIN               AutoCfgClean           bool
//     MAIN               KeepNetLst             bool
//     MAIN               PosnX                  int
//     MAIN               PosnY                  int
//     MAIN               SizeW                  int
//     MAIN               SizeH                  int
//     HELP               PosnX                  int
//     HELP               PosnY                  int
//     HELP               SizeW                  int
//     HELP               SizeH                  int
//     HELP               PdfViewer              wxString
//     FILES              NetList                wxString
//     FILES              Schematics             wxString or wxArrayString
//     FILES              Recent                 wxString or wxArrayString
//     FILES              DirLastAcc             wxString
//     NETLISTER          VerboseMode            bool
//     NETLISTER          GuileProc              wxString
//     NETLISTER          IncludeMode            bool
//     NETLISTER          EmbedMode              bool
//     NETLISTER          NoMungeMode            bool
//     SIM_ENGINE         Engine                 wxString or eTypeSimEng
//     SIM_ENGINE         Analysis               wxString or eTypeCmd
//     SIM_ENGINE         PhaseUnits             wxString or eTypeUnits
//     SIM_ENGINE         SyncSigSrcs            bool
//     SIM_ENGINE         SyncTemps              bool
//     SIM_ENGINE         AutoRegen              bool
//     EDA_TOOL_SUITE     Project                wxString or eTypeEDA
//     DATA_VIEWER        Utility                wxString or eTypeDatVwr
//**************************************************************************************************

#ifndef CONFIG_HPP
#define CONFIG_HPP

// Application Includes

#include "Version.hpp"
#include "TypeDefs.hpp"
#include "CmdLinePcr.hpp"
#include "utility/PnlTxtSpn.hpp"
#include "utility/StrUtils.hpp"

// wxWidgets Includes

#include <wx/config.h>

// Local constant declarations

// MAIN           group
#define  CFG_DEF_APP_VERSION   wxEmptyString
#define  CFG_DEF_TMPFILEMGT    eTFM_DELETE
#define  CFG_DEF_FRMLAYOUT     0
#define  CFG_DEF_PRECISION     CNVT_DEF_FLT_RES
#define  CFG_DEF_NBKMAXLNS     TXT_LNSDEF
#define  CFG_DEF_SPNPERIOD     SPN_PERIOD_DEF
#define  CFG_DEF_TOOLTIPDLY    700
#define  CFG_DEF_TOOLTIPS      false
#define  CFG_DEF_AUTOCFGCLEAN  true
#define  CFG_DEF_KEEPNETLST    false
#define  CFG_DEF_MAINPOSNX     100
#define  CFG_DEF_MAINPOSNY     100
#define  CFG_DEF_MAINSIZEW     793
#define  CFG_DEF_MAINSIZEH     623

// HELP           group
#define  CFG_DEF_HELPPOSNX     500
#define  CFG_DEF_HELPPOSNY     1
#define  CFG_DEF_HELPSIZEW     500
#define  CFG_DEF_HELPSIZEH     700

// NETLISTER      group
#define  CFG_DEF_GUILEPROC     "spice-msw"
#define  CFG_DEF_VERBOSEMODE   false
#define  CFG_DEF_INCLUDEMODE   false
#define  CFG_DEF_EMBEDMODE     false
#define  CFG_DEF_NOMUNGEMODE   false

// SIM_ENGINE     group
#define  CFG_DEF_SIMENGINE     "NG-SPICE"
#define  CFG_DEF_ANALYSIS      "OP"
#define  CFG_DEF_PHASEUNITS    "Degrees"
#define  CFG_DEF_SYNCSIGSRCS   true
#define  CFG_DEF_SYNCTEMPS     true
#define  CFG_DEF_AUTOREGEN     false

// EDA_TOOL_SUITE group
#define  CFG_DEF_EDATOOLSUITE  "gEDA-gaf"

// DATA_VIEWER    group
#define  CFG_DEF_DATAVIEWER    wxEmptyString

// CALCULATOR     group
#define  CFG_DEF_CALCULATOR    wxEmptyString

// PDF_VIEWER     group
#define  CFG_DEF_PDFVIEWER     wxEmptyString

//**************************************************************************************************

class Config
{
  private :

            wxFileName  m_ofnFileName;  // The RC file name
    static  wxConfig *  m_poCfg;        // Pointer to the wxWidgets configuration object

  public :

          Config( void );
         ~Config( );

    bool  bOpen  ( const wxString & rosFileName=wxEmptyString );
    bool  bIsOpen( void ) { return( m_poCfg != NULL ); }
    bool  bClose ( void );
    bool  bFlush ( void );
    bool  bClean ( void );

    // Set / get the configuration file name
          bool         bSetFileName( const wxString & rosFileName );
    const wxString & rosGetFileName( void );

    // Set / get configuration parameters
    // (Using these functions would make the class smaller but when the configuration file format
    // changes the whole code base must be updated to reflect the changes.)
          bool         bSet( const wxString & rosGroup, const wxString & rosKey,
                                   int          iValue );
          bool         bSet( const wxString & rosGroup, const wxString & rosKey,
                                   bool         bValue );
          bool         bSet( const wxString & rosGroup, const wxString & rosKey,
                             const wxString & rosValue );

          int          iGet( const wxString & rosGroup, const wxString & rosKey,
                                   int          iDefault=INT_MIN );
          bool         bGet( const wxString & rosGroup, const wxString & rosKey,
                                   bool         bDefault=false );
    const wxString & rosGet( const wxString & rosGroup, const wxString & rosKey,
                             const wxString & rosDefault=wxEmptyString );

    // Set configuration parameter functions
    // (These functions makes the class larger but when the configuration file format changes the
    // impact is contained within this class not the whole code base.)
    bool  bSetAppVersion  ( const wxString & rosAppVersion   );  // MAIN           group
    bool  bSetFrmLayout   ( uint             uiLayout        );
    bool  bSetTmpFileMgt  ( eTypeTmpFileMgt  eTmpFileMgt     );
    bool  bSetPrecision   ( uint             uiFltRes        );
    bool  bSetNbkMaxLns   ( uint             uiLnCnt         );
    bool  bSetSpnPeriod   ( uint             ui_mSec         );
    bool  bSetToolTipDly  ( uint             ui_mSec         );
    bool  bSetToolTips    ( bool             bEnable         );
    bool  bSetAutoCfgClean( bool             bEnable         );
    bool  bSetKeepNetLst  ( bool             bEnable         );
    bool  bSetMainPosnX   ( int              iPosnX          );
    bool  bSetMainPosnY   ( int              iPosnY          );
    bool  bSetMainSizeW   ( int              iSizeW          );
    bool  bSetMainSizeH   ( int              iSizeH          );

    bool  bSetHelpPosnX   ( int              iPosnX          );  // HELP           group
    bool  bSetHelpPosnY   ( int              iPosnY          );
    bool  bSetHelpSizeW   ( int              iSizeW          );
    bool  bSetHelpSizeH   ( int              iSizeH          );

    bool  bSetNetLstFile  ( const wxString      &  rosFile   );  // FILES          group
    bool  bSetSchemFiles  ( const wxString      &  rosFiles  );
    bool  bSetSchemFiles  ( const wxArrayString & roasFiles  );
    bool  bSetRecentFiles ( const wxString      &  rosFiles  );
    bool  bSetRecentFiles ( const wxArrayString & roasFiles  );
    bool  bSetDirLastAcc  ( const wxString      &  rosDir    );

    bool  bSetGuileProc   ( const wxString & rosGuileProc    );  // NETLISTER      group
    bool  bSetVerboseMode ( bool             bEnable         );
    bool  bSetIncludeMode ( bool             bEnable         );
    bool  bSetEmbedMode   ( bool             bEnable         );
    bool  bSetNoMungeMode ( bool             bEnable         );

    bool  bSetSimEngine   ( const wxString & rosSimEngine    );  // SIM_ENGINE     group
    bool  bSetSimEngine   ( eTypeSimEng      eSimEngine      );
    bool  bSetAnalysis    ( eTypeCmd         eAnalysis       );
    bool  bSetPhaseUnits  ( eTypeUnits       eUnits          );
    bool  bSetSyncSigSrcs ( bool             bEnable         );
    bool  bSetSyncTemps   ( bool             bEnable         );
    bool  bSetAutoRegen   ( bool             bEnable         );

    bool  bSetEdaToolSuite( const wxString & rosEdaToolSuite );  // EDA_TOOL_SUITE group
    bool  bSetEdaToolSuite( eTypeEDA           eEdaToolSuite );

    bool  bSetDataViewer  ( const wxString & rosDataViewer   );  // DATA_VIEWER    group
    bool  bSetDataViewer  ( eTypeDatVwr        eDataViewer   );

    bool  bSetCalculator  ( const wxString & rosCalculator   );  // CALCULATOR     group

    bool  bSetPdfViewer   ( const wxString & rosPdfViewer    );  // PDF_VIEWER     group

    // Get configuration parameter functions
    const wxString      &  rosGetAppVersion  ( void );  // MAIN           group
          uint              uiGetFrmLayout   ( void );
          eTypeTmpFileMgt    eGetTmpFileMgt  ( void );
          uint              uiGetPrecision   ( void );
          uint              uiGetNbkMaxLns   ( void );
          uint              uiGetSpnPeriod   ( void );
          uint              uiGetToolTipDly  ( void );
          bool               bGetToolTips    ( void );
          bool               bGetAutoCfgClean( void );
          bool               bGetKeepNetLst  ( void );
          int                iGetMainPosnX   ( void );
          int                iGetMainPosnY   ( void );
          int                iGetMainSizeW   ( void );
          int                iGetMainSizeH   ( void );

          int                iGetHelpPosnX   ( void );  // HELP           group
          int                iGetHelpPosnY   ( void );
          int                iGetHelpSizeW   ( void );
          int                iGetHelpSizeH   ( void );

    const wxString      &  rosGetNetLstFile  ( void );  // FILES          group
    const wxString      &  rosGetSchemFiles  ( void );
    const wxArrayString & roasGetSchemFiles  ( void );
    const wxString      &  rosGetRecentFiles ( void );
    const wxArrayString & roasGetRecentFiles ( void );
    const wxString      &  rosGetDirLastAcc  ( void );

    const wxString      &  rosGetGuileProc   ( void );  // NETLISTER      group
          bool               bGetVerboseMode ( void );
          bool               bGetIncludeMode ( void );
          bool               bGetEmbedMode   ( void );
          bool               bGetNoMungeMode ( void );

    const wxString      &  rosGetSimEngine   ( void );  // SIM_ENGINE     group
          eTypeSimEng        eGetSimEngine   ( void );
    const wxString      &  rosGetAnalysis    ( void );
          eTypeCmd           eGetAnalysis    ( void );
    const wxString      &  rosGetPhaseUnits  ( void );
          eTypeUnits         eGetPhaseUnits  ( void );
          bool               bGetSyncSigSrcs ( void );
          bool               bGetSyncTemps   ( void );
          bool               bGetAutoRegen   ( void );

    const wxString      &  rosGetEdaToolSuite( void );  // EDA_TOOL_SUITE group
          eTypeEDA           eGetEdaToolSuite( void );

    const wxString      &  rosGetDataViewer  ( void );  // DATA_VIEWER    group
          eTypeDatVwr        eGetDataViewer  ( void );

    const wxString      &  rosGetCalculator  ( void );  // CALCULATOR     group

    const wxString      &  rosGetPdfViewer   ( void );  // PDF_VIEWER     group

    // The following function is intended for debugging
    void  Print( const wxString & rosPrefix="  " );
};

//**************************************************************************************************

#endif // CONFIG_HPP
