/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.commons.java.datastructure;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class LookupCache {
    private static final Logger _logger = Logger.getLogger((class$org$onemind$commons$java$datastructure$LookupCache == null ? (class$org$onemind$commons$java$datastructure$LookupCache = LookupCache.class$("org.onemind.commons.java.datastructure.LookupCache")) : class$org$onemind$commons$java$datastructure$LookupCache).getName());
    private Map _cache = new HashMap();
    private Set _negCache;
    private boolean _doNegCache = true;
    static /* synthetic */ Class class$org$onemind$commons$java$datastructure$LookupCache;

    public LookupCache() {
        this(true);
    }

    public LookupCache(boolean doNegCache) {
        this.setDoNegativeCache(doNegCache);
    }

    protected final Object lookup(Object key) {
        if (this._doNegCache && this._negCache.contains(key)) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Returning negative cache hit");
            }
            return null;
        }
        Object o = this._cache.get(key);
        if (o == null) {
            o = this.produce(key);
            if (o != null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Put hit of " + key + " to cache");
                }
                this._cache.put(key, o);
            } else if (this._doNegCache) {
                _logger.finest("Put negative hit of " + key + " to cache");
                this._negCache.add(key);
            }
        } else if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Returning positive cache hit of " + key);
        }
        return o;
    }

    protected abstract Object produce(Object var1);

    protected void setDoNegativeCache(boolean b) {
        this._doNegCache = b;
        if (b && this._negCache == null) {
            this._negCache = new HashSet();
        }
    }

    protected boolean isInNegCache(Object o) {
        return this._negCache.contains(o);
    }

    protected boolean isInCache(Object o) {
        return this._cache.containsKey(o);
    }

    protected void clearNegCache() {
        if (this._negCache != null) {
            this._negCache.clear();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

