/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.Incubating;
import org.gradle.api.problems.BuildableProblemBuilder;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.ProblemBuilder;
import org.gradle.api.problems.ProblemBuilderDefiningCategory;
import org.gradle.api.problems.ProblemBuilderDefiningDocumentation;
import org.gradle.api.problems.ProblemBuilderDefiningLabel;
import org.gradle.api.problems.ProblemBuilderDefiningLocation;
import org.gradle.api.problems.ReportableProblem;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DefaultProblemCategory;
import org.gradle.api.problems.internal.DefaultReportableProblem;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.locations.FileLocation;
import org.gradle.api.problems.locations.PluginIdLocation;
import org.gradle.api.problems.locations.ProblemLocation;

@Incubating
public class DefaultBuildableProblemBuilder
implements BuildableProblemBuilder,
ProblemBuilderDefiningDocumentation,
ProblemBuilderDefiningLocation,
ProblemBuilderDefiningLabel,
ProblemBuilderDefiningCategory {
    private String label;
    private String problemCategory;
    private final InternalProblems problemsService;
    private Severity severity;
    private List<ProblemLocation> locations = new ArrayList<ProblemLocation>();
    private String description;
    private DocLink documentationUrl;
    private boolean explicitlyUndocumented = false;
    private List<String> solution;
    private RuntimeException exception;
    protected final Map<String, String> additionalMetadata = new HashMap<String, String>();
    private boolean collectLocation = false;

    public DefaultBuildableProblemBuilder(InternalProblems problemsService) {
        this.problemsService = problemsService;
    }

    @Override
    public ProblemBuilderDefiningDocumentation label(String label, Object ... args) {
        this.label = String.format(label, args);
        return this;
    }

    @Override
    public BuildableProblemBuilder severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public ProblemBuilderDefiningCategory location(String path, @Nullable Integer line) {
        this.location(path, line, null);
        return this;
    }

    public ProblemBuilderDefiningCategory location(String path, @Nullable Integer line, @Nullable Integer column) {
        this.locations.add(new FileLocation(path, line, column, 0));
        return this;
    }

    @Override
    public ProblemBuilderDefiningCategory fileLocation(String path, @Nullable Integer line, @Nullable Integer column, @Nullable Integer length) {
        this.locations.add(new FileLocation(path, line, column, length));
        return this;
    }

    @Override
    public ProblemBuilderDefiningCategory pluginLocation(String pluginId) {
        this.locations.add(new PluginIdLocation(pluginId));
        return this;
    }

    @Override
    public ProblemBuilderDefiningCategory stackLocation() {
        this.collectLocation = true;
        return this;
    }

    @Override
    public ProblemBuilderDefiningCategory noLocation() {
        return this;
    }

    @Override
    public BuildableProblemBuilder details(String details) {
        this.description = details;
        return this;
    }

    @Override
    public ProblemBuilderDefiningLocation documentedAt(DocLink doc) {
        this.documentationUrl = doc;
        return this;
    }

    @Override
    public ProblemBuilderDefiningLocation undocumented() {
        this.explicitlyUndocumented = true;
        return this;
    }

    @Override
    public ProblemBuilder category(String category, String ... details) {
        this.problemCategory = DefaultProblemCategory.category(category, details).toString();
        return this;
    }

    @Override
    public BuildableProblemBuilder solution(@Nullable String solution) {
        if (this.solution == null) {
            this.solution = new ArrayList<String>();
        }
        this.solution.add(solution);
        return this;
    }

    @Override
    public BuildableProblemBuilder additionalData(String key, String value) {
        this.additionalMetadata.put(key, value);
        return this;
    }

    @Override
    public BuildableProblemBuilder withException(RuntimeException e) {
        this.exception = e;
        return this;
    }

    @Override
    public ReportableProblem build() {
        return this.buildInternal(null);
    }

    @Nonnull
    private ReportableProblem buildInternal(@Nullable Severity severity) {
        if (!this.explicitlyUndocumented && this.documentationUrl == null) {
            throw new IllegalStateException("Problem is not documented: " + this.label);
        }
        return new DefaultReportableProblem(this.label, this.getSeverity(severity), this.locations, this.documentationUrl, this.description, this.solution, this.exception == null && this.collectLocation ? new Exception() : this.exception, this.problemCategory, this.additionalMetadata, this.problemsService);
    }

    @Nonnull
    private Severity getSeverity(@Nullable Severity severity) {
        if (severity != null) {
            return severity;
        }
        return this.getSeverity();
    }

    private Severity getSeverity() {
        if (this.severity == null) {
            return Severity.WARNING;
        }
        return this.severity;
    }

    RuntimeException getException() {
        return this.exception;
    }
}

