/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import net.yura.mobile.io.ServiceLink;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.QueueProcessorThread;

public class RMSBackup
extends QueueProcessorThread {
    private String rmsName;
    private RMSBackupHelper helper;
    private Hashtable table = new Hashtable();

    public RMSBackup(RMSBackupHelper help, String n) {
        super("RMSBackup-" + n);
        this.rmsName = n;
        this.helper = help;
    }

    public void clearBackup() {
        try {
            RecordStore.deleteRecordStore((String)this.rmsName);
        }
        catch (Exception ex) {
            Logger.info("can not del RMS");
        }
        this.table.clear();
    }

    public Vector recover() throws Exception {
        Vector<Object> current = new Vector<Object>();
        RecordStore recordStore = RecordStore.openRecordStore((String)this.rmsName, (boolean)true);
        if (recordStore.getNumRecords() != 0) {
            if (!this.isRunning()) {
                this.start();
            }
            RecordEnumeration re = recordStore.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                int id = re.nextRecordId();
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(recordStore.getRecord(id));
                    Object currentBooking = this.helper.loadObject(bais);
                    this.table.put(this.helper.getObjectId(currentBooking), new Integer(id));
                    current.addElement(currentBooking);
                }
                catch (Exception ex) {
                    recordStore.deleteRecord(id);
                    Logger.warn("Error loading RMS: " + this.rmsName + " record id=" + id, ex);
                }
            }
        }
        recordStore.closeRecordStore();
        return current;
    }

    public void backup(Object obj) {
        this.makeSureIsRunning();
        this.addToInbox(new ServiceLink.Task("save", obj));
    }

    public void remove(Object objId) {
        this.makeSureIsRunning();
        this.addToInbox(new ServiceLink.Task("del", objId));
    }

    private void makeSureIsRunning() {
        if (!this.isRunning()) {
            try {
                this.start();
            }
            catch (IllegalThreadStateException ex) {
                Logger.info(null, ex);
            }
        }
    }

    public void process(Object param) throws Exception {
        ServiceLink.Task task = (ServiceLink.Task)param;
        Object obj = task.getObject();
        String method = task.getMethod();
        if ("del".equals(method)) {
            Integer i = (Integer)this.table.remove(obj);
            if (i != null) {
                RecordStore recordStore = RecordStore.openRecordStore((String)this.rmsName, (boolean)true);
                recordStore.deleteRecord(i.intValue());
                recordStore.closeRecordStore();
            } else {
                System.err.println("[RMSBackup] ERROR: can not del " + obj + " from " + this.table);
            }
        } else if ("save".equals(method)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.helper.saveObject(baos, obj);
            byte[] b = baos.toByteArray();
            RecordStore recordStore = RecordStore.openRecordStore((String)this.rmsName, (boolean)true);
            int size = recordStore.getSizeAvailable();
            if (size <= b.length) {
                recordStore.closeRecordStore();
                this.helper.rmsSaveFailed("no space: availableSize=" + size + " recordSize=" + b.length);
            } else {
                Object bookingId = this.helper.getObjectId(obj);
                Integer i = (Integer)this.table.get(bookingId);
                if (i == null) {
                    Integer newRecordId = new Integer(recordStore.addRecord(b, 0, b.length));
                    this.table.put(bookingId, newRecordId);
                } else {
                    recordStore.setRecord(i.intValue(), b, 0, b.length);
                }
                recordStore.closeRecordStore();
            }
        } else {
            System.out.println("unknwon method in RMSBackup queue: " + method);
        }
    }

    public static interface RMSBackupHelper {
        public Object getObjectId(Object var1);

        public Object loadObject(InputStream var1) throws Exception;

        public void saveObject(OutputStream var1, Object var2) throws Exception;

        public void rmsSaveFailed(String var1);
    }
}

