/*
 * Decompiled with CFR 0.152.
 */
package net.yura.translation;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import net.yura.translation.MessageTool;
import net.yura.translation.Mtcomm;
import net.yura.translation.PartnerNode;

public class MyNode
extends DefaultMutableTreeNode {
    private boolean hasmessage;
    private HashMap map;
    private boolean haschildren;
    private boolean needchildren;
    private boolean workneeded;

    public MyNode(String name, boolean hasm, boolean hasch) {
        super(name);
        this.hasmessage = hasm;
        this.haschildren = hasch;
        this.setup();
    }

    protected MyNode(String name, boolean a) {
        super(name);
        if (a) {
            this.hasmessage = true;
            this.map = new HashMap();
        } else {
            this.haschildren = true;
        }
    }

    private void setup() {
        if (this.haschildren && this.isLeaf()) {
            this.add(new MyNode(null, false, false));
            this.needchildren = true;
        }
        if (this.hasmessage && this.map == null) {
            this.map = new HashMap();
        }
    }

    public void removeAllChildren() {
        if (this.haschildren) {
            super.removeAllChildren();
            this.setup();
        }
    }

    public void add(MutableTreeNode newChild) {
        if (this.children != null) {
            MyNode newNode = (MyNode)newChild;
            for (int c = 0; c < this.children.size(); ++c) {
                MyNode child = (MyNode)this.children.elementAt(c);
                if (!child.getUserObject().equals(newNode.getUserObject())) continue;
                if (!child.hasMessage() && newNode.hasMessage()) {
                    child.hasmessage = true;
                    child.setup();
                }
                if (!child.hasChildren() && newNode.hasChildren()) {
                    child.haschildren = true;
                    child.setup();
                }
                return;
            }
        }
        super.add(newChild);
        Collections.sort(this.children, MessageTool.CASE_POSTERIORITY_ORDER);
    }

    public void setHasChildren(boolean b) {
        this.haschildren = b;
    }

    public void setHasMessage(boolean b) {
        this.hasmessage = b;
        this.setup();
    }

    public boolean hasMessage() {
        return this.hasmessage;
    }

    public boolean hasChildren() {
        return this.haschildren;
    }

    public boolean workNeeded() {
        return this.workneeded;
    }

    public void setWorkNeeded(boolean a) {
        this.workneeded = a;
    }

    public String reload(Mtcomm mycomm, PartnerNode p, Locale l) throws Exception {
        String m = mycomm.getMessage(this, p, l);
        this.map.put(l, m);
        return m;
    }

    public String getMessage(Mtcomm mycomm, PartnerNode p, Locale l) throws Exception {
        if (this.map.containsKey(l)) {
            return (String)this.map.get(l);
        }
        return this.reload(mycomm, p, l);
    }

    public void saveMessage(Mtcomm mycomm, PartnerNode p, Locale l, String m, Locale currentlocale) throws Exception {
        mycomm.saveMessage(this, p, l, m);
        this.map.put(l, m);
        this.checkBackWorkNeeded(mycomm, currentlocale);
    }

    private void checkBackWorkNeeded(Mtcomm mycomm, Locale currentlocale) throws Exception {
        mycomm.setupMissingTranslation(this, currentlocale);
        if (this.workneeded) {
            this.checkBackWorkNeededSetTrue();
        } else {
            MyNode p = (MyNode)this.getParent();
            if (p != null && p.workNeeded()) {
                p.checkBackWorkNeeded(mycomm, currentlocale);
            }
        }
    }

    private void checkBackWorkNeededSetTrue() {
        this.workneeded = true;
        MyNode p = (MyNode)this.getParent();
        if (p != null && !p.workNeeded()) {
            p.checkBackWorkNeededSetTrue();
        }
    }

    public void loadChildren(Mtcomm mycomm, Locale currentlocale) throws Exception {
        if (this.needchildren) {
            this.needchildren = false;
            this.remove(0);
            mycomm.addChildren(this);
            if (this.workneeded && this.haschildren) {
                Enumeration<TreeNode> en = this.children();
                while (en.hasMoreElements()) {
                    MyNode node = (MyNode)en.nextElement();
                    mycomm.setupMissingTranslation(node, currentlocale);
                }
            }
        }
    }

    public void nodeWorkRefresh(Mtcomm mycomm, Locale currentlocale) throws Exception {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean before = this.workneeded;
        mycomm.setupMissingTranslation(this, currentlocale);
        if ((before && !this.workneeded || this.workneeded) && !this.needchildren && this.haschildren) {
            Enumeration<TreeNode> en = this.children();
            while (en.hasMoreElements()) {
                MyNode node = (MyNode)en.nextElement();
                node.nodeWorkRefresh(mycomm, currentlocale);
            }
        }
    }

    public String getName() {
        TreeNode[] path = this.getPath();
        StringBuffer buffer = new StringBuffer();
        for (int c = 1; c < path.length; ++c) {
            buffer.append(path[c]);
            if (c >= path.length - 1) continue;
            buffer.append(".");
        }
        return buffer.toString();
    }

    public MyNode getChild(String s) {
        if (this.isLeaf()) {
            return null;
        }
        int a = Collections.binarySearch(this.children, s, MessageTool.CASE_POSTERIORITY_ORDER);
        if (a < 0) {
            return null;
        }
        return (MyNode)this.children.elementAt(a);
    }
}

