/*
 * Decompiled with CFR 0.152.
 */
package net.yura.translation.plugins;

import java.awt.Component;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.yura.translation.Mtcomm;
import net.yura.translation.MyNode;
import net.yura.translation.PartnerNode;
import net.yura.translation.Result;
import net.yura.translation.plugins.TestComm;

public class NetComm
implements Mtcomm {
    private Socket socket;
    private ObjectOutputStream out;
    private ObjectInputStream in;

    public boolean load() throws Exception {
        String auth = NetComm.getLogin(null, this.getAuth(""));
        if (auth != null) {
            this.saveAuth(auth);
            this.load(auth);
            return true;
        }
        return false;
    }

    public void load(String auth) throws Exception {
        String port = NetComm.getPort(auth);
        int portInt = "".equals(port) ? 8096 : Integer.parseInt(port);
        this.socket = new Socket(NetComm.getServer(auth), portInt);
        this.out = new ObjectOutputStream(this.socket.getOutputStream());
        this.in = new ObjectInputStream(this.socket.getInputStream());
        PublicKey pubk = (PublicKey)this.in.readObject();
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, pubk);
        byte[] name = cipher.doFinal(NetComm.getUsername(auth).getBytes());
        byte[] pass = cipher.doFinal(NetComm.getPassword(auth).getBytes());
        Object[] messages = new Object[]{name, pass, "1", this.getRemoteClass().getName()};
        System.out.println(this.callMethod("Hello", messages));
    }

    public Class getRemoteClass() {
        return TestComm.class;
    }

    public void saveAuth(String auth) {
    }

    public String getAuth(String defaultAuth) {
        return defaultAuth;
    }

    public PartnerNode[] getPartners() throws Exception {
        return (PartnerNode[])this.callMethod("getPartners", new Object[0]);
    }

    public Locale[] getLocales() throws Exception {
        return (Locale[])this.callMethod("getLocales", new Object[0]);
    }

    public Result[] search(String s) throws Exception {
        Object[] messages = new Object[]{s};
        return (Result[])this.callMethod("search", messages);
    }

    public String getMessage(MyNode node, PartnerNode partner, Locale l) throws Exception {
        Object[] messages = new Object[]{node.getName(), partner, l};
        return (String)this.callMethod("getMessage", messages);
    }

    public void addChildren(MyNode node) throws Exception {
        Object[] messages = new Object[]{node.getName()};
        Vector nodes = (Vector)this.callMethod("getChildren", messages);
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            TheNode newNode = (TheNode)i.next();
            node.add(new MyNode(newNode.name, newNode.hasmessage, newNode.haschildren));
        }
    }

    public void saveMessage(MyNode node, PartnerNode partner, Locale l, String message) throws Exception {
        Object[] messages = new Object[]{node.getName(), partner, l, message};
        this.callMethod("saveMessage", messages);
    }

    public void setupMissingTranslation(MyNode node, Locale l) throws Exception {
        Object[] messages = new Object[]{node.getName(), l};
        Boolean bool = (Boolean)this.callMethod("getMissingTranslation", messages);
        node.setWorkNeeded(bool);
    }

    public synchronized Object callMethod(String name, Object[] a) throws Exception {
        TheMethod method = new TheMethod();
        method.name = name;
        method.params = a;
        this.out.writeObject(method);
        Object o = this.in.readObject();
        if (o instanceof Exception) {
            throw (Exception)o;
        }
        return o;
    }

    static String getUsername(String auth) {
        int at = auth.lastIndexOf(64);
        if (at >= 0) {
            String first = auth.substring(0, at);
            int colon = first.indexOf(58);
            if (colon >= 0) {
                return first.substring(0, colon);
            }
            return first;
        }
        return "";
    }

    static String getPassword(String auth) {
        int at = auth.lastIndexOf(64);
        if (at >= 0) {
            String first = auth.substring(0, at);
            int colon = first.indexOf(58);
            if (colon >= 0) {
                return first.substring(colon + 1);
            }
            return "";
        }
        return "";
    }

    static String getServer(String auth) {
        int at = auth.lastIndexOf(64);
        String first = at >= 0 ? auth.substring(at + 1) : auth;
        int colon = first.lastIndexOf(58);
        if (colon >= 0) {
            return first.substring(0, colon);
        }
        return first;
    }

    static String getPort(String auth) {
        int at = auth.lastIndexOf(64);
        String first = at >= 0 ? auth.substring(at + 1) : auth;
        int colon = first.lastIndexOf(58);
        if (colon >= 0) {
            return first.substring(colon + 1);
        }
        return "";
    }

    public static String getLogin(Component parentComponent, String auth) {
        Object[] message = new Object[6];
        message[0] = "server name:";
        String port = NetComm.getPort(auth);
        message[1] = new JTextField(NetComm.getServer(auth) + ("".equals(port) ? "" : ":" + port));
        message[2] = "user name:";
        message[3] = new JTextField(NetComm.getUsername(auth));
        message[4] = "password:";
        message[5] = new JPasswordField(NetComm.getPassword(auth));
        Object[] options = new String[]{"OK", "cancel"};
        int result = JOptionPane.showOptionDialog(parentComponent, message, "login to server", 2, 3, null, options, options[0]);
        if (result == 0) {
            String username = ((JTextField)message[3]).getText();
            String password = new String(((JPasswordField)message[5]).getPassword());
            return username + ("".equals(password) ? "" : ":" + password) + ("".equals(username) && "".equals(password) ? "" : "@") + ((JTextField)message[1]).getText();
        }
        return null;
    }

    public static class TheMethod
    implements Serializable {
        public String name;
        public Object[] params;

        public String toString() {
            return this.name + " " + (this.params == null ? "no params" : String.valueOf(Arrays.asList(this.params)));
        }
    }

    public static class TheNode
    implements Serializable {
        public String name;
        public boolean hasmessage;
        public boolean haschildren;
    }
}

