/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;

public class PatternMatchTestClassProcessor
implements TestClassProcessor {
    private final TestSelectionMatcher testClassSelectionMatcher;
    private final TestClassProcessor delegate;

    public PatternMatchTestClassProcessor(DefaultTestFilter testFilter, TestClassProcessor delegate) {
        this.testClassSelectionMatcher = new TestSelectionMatcher(testFilter.toSpec());
        this.delegate = delegate;
    }

    public void startProcessing(TestResultProcessor resultProcessor) {
        this.delegate.startProcessing(resultProcessor);
    }

    public void processTestClass(TestClassRunInfo testClass) {
        if (this.testClassSelectionMatcher.mayIncludeClass(testClass.getTestClassName())) {
            this.delegate.processTestClass(testClass);
        }
    }

    public void stop() {
        this.delegate.stop();
    }

    public void stopNow() {
        this.delegate.stopNow();
    }
}

