/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.token;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;

public class EscapingWriter
extends FilterWriter {
    private static final Map<Character, char[]> REPLACE = ImmutableMap.builder().put(Character.valueOf('\\'), new char[]{'\\', '\\'}).put(Character.valueOf('\n'), new char[]{'\\', 'n'}).put(Character.valueOf('\r'), new char[]{'\\', 'r'}).put(Character.valueOf('\f'), new char[]{'\\', 'f'}).put(Character.valueOf('\''), new char[]{'\\', '\''}).put(Character.valueOf('\"'), new char[]{'\\', '\"'}).build();
    private final char[] escapedBuffer = new char[256];
    private Map<Character, Integer> escapedCounts = Maps.newHashMap();

    public EscapingWriter(Writer out) {
        super(out);
        for (Character key : REPLACE.keySet()) {
            this.escapedCounts.put(key, 0);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int pos = 0;
        for (int i = off; i < len; ++i) {
            Character character = Character.valueOf(cbuf[i]);
            if (REPLACE.containsKey(character)) {
                pos = this.writeToBuffer(pos, REPLACE.get(character));
                this.escapedCounts.put(character, this.escapedCounts.get(character) + 1);
                continue;
            }
            pos = this.writeToBuffer(pos, character.charValue());
        }
        this.out.write(this.escapedBuffer, 0, pos);
    }

    private int writeToBuffer(int pos, char c) throws IOException {
        if (pos + 1 > this.escapedBuffer.length) {
            this.out.write(this.escapedBuffer, 0, pos);
            pos = 0;
        }
        this.escapedBuffer[pos++] = c;
        return pos;
    }

    private int writeToBuffer(int pos, char[] characters) throws IOException {
        if (pos + characters.length > this.escapedBuffer.length) {
            this.out.write(this.escapedBuffer, 0, pos);
            pos = 0;
        }
        System.arraycopy(characters, 0, this.escapedBuffer, 0, pos);
        return pos += characters.length;
    }

    public void write(int c) throws IOException {
        Character chr = Character.valueOf((char)c);
        if (REPLACE.containsKey(chr)) {
            this.out.write(REPLACE.get(chr));
            this.escapedCounts.put(chr, this.escapedCounts.get(chr) + 1);
        } else {
            this.out.write(c);
        }
    }

    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    public int getEscapedCount(char character) {
        return this.escapedCounts.get(Character.valueOf(character));
    }

    public String toString() {
        return "EscapingWriter [escapedBuffer=" + Arrays.toString(this.escapedBuffer) + ", escapedCounts=" + this.escapedCounts + "]";
    }
}

