/* ccdsNotes.c was originally generated by the autoSql program, which also 
 * generated ccdsNotes.h and ccdsNotes.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "ccdsNotes.h"


void ccdsNotesStaticLoad(char **row, struct ccdsNotes *ret)
/* Load a row from ccdsNotes table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

safecpy(ret->ccds, sizeof(ret->ccds), row[0]);
safecpy(ret->createDate, sizeof(ret->createDate), row[1]);
ret->note = row[2];
}

struct ccdsNotes *ccdsNotesLoad(char **row)
/* Load a ccdsNotes from row fetched with select * from ccdsNotes
 * from database.  Dispose of this with ccdsNotesFree(). */
{
struct ccdsNotes *ret;

AllocVar(ret);
safecpy(ret->ccds, sizeof(ret->ccds), row[0]);
safecpy(ret->createDate, sizeof(ret->createDate), row[1]);
ret->note = cloneString(row[2]);
return ret;
}

struct ccdsNotes *ccdsNotesLoadAll(char *fileName) 
/* Load all ccdsNotes from a whitespace-separated file.
 * Dispose of this with ccdsNotesFreeList(). */
{
struct ccdsNotes *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = ccdsNotesLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ccdsNotes *ccdsNotesLoadAllByChar(char *fileName, char chopper) 
/* Load all ccdsNotes from a chopper separated file.
 * Dispose of this with ccdsNotesFreeList(). */
{
struct ccdsNotes *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = ccdsNotesLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ccdsNotes *ccdsNotesCommaIn(char **pS, struct ccdsNotes *ret)
/* Create a ccdsNotes out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ccdsNotes */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
sqlFixedStringComma(&s, ret->ccds, sizeof(ret->ccds));
sqlFixedStringComma(&s, ret->createDate, sizeof(ret->createDate));
ret->note = sqlStringComma(&s);
*pS = s;
return ret;
}

void ccdsNotesFree(struct ccdsNotes **pEl)
/* Free a single dynamically allocated ccdsNotes such as created
 * with ccdsNotesLoad(). */
{
struct ccdsNotes *el;

if ((el = *pEl) == NULL) return;
freeMem(el->note);
freez(pEl);
}

void ccdsNotesFreeList(struct ccdsNotes **pList)
/* Free a list of dynamically allocated ccdsNotes's */
{
struct ccdsNotes *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    ccdsNotesFree(&el);
    }
*pList = NULL;
}

void ccdsNotesOutput(struct ccdsNotes *el, FILE *f, char sep, char lastSep) 
/* Print out ccdsNotes.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ccds);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->createDate);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->note);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */


static char *createSql =
    /* SQL to create ccdsNotes format table */
    "CREATE TABLE %s (\n"
    "    ccds char(12) not null,	# CCDS id\n"
    "    createDate char(10) not null,	# date note was added\n"
    "    note longblob not null,	# text of note\n"
    "    INDEX(ccds)\n"
    ");\n";

char *ccdsNotesGetCreateSql(char *table)
/* Get sql command to create ccdsNotes table. Result should be freed. */
{
char sql[1024];
safef(sql, sizeof(sql), createSql, table);
return cloneString(sql);
}

