/* ocp.c was originally generated by the autoSql program, which also 
 * generated ocp.h and ocp.sql.  This module links the database and the RAM 
 * representation of objects. */

#include "common.h"
#include "jksql.h"
#include "linefile.h"
#include "ocp.h"


void ocpStaticLoad(char **row, struct ocp *ret)
/* Load a row from ocp table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
int sizeOne,i;
char *s;

ret->aName = row[0];
ret->aSize = sqlSigned(row[1]);
ret->aHitS = row[2][0];
ret->aHitT = row[3][0];
ret->bName = row[4];
ret->bSize = sqlSigned(row[5]);
ret->bHitS = row[6][0];
ret->bHitT = row[7][0];
ret->overlap = sqlSigned(row[8]);
ret->reserved = sqlSigned(row[9]);
}

struct ocp *ocpLoad(char **row)
/* Load a ocp from row fetched with select * from ocp
 * from database.  Dispose of this with ocpFree(). */
{
struct ocp *ret;
int sizeOne,i;
char *s;

AllocVar(ret);
ret->aName = cloneString(row[0]);
ret->aSize = sqlSigned(row[1]);
ret->aHitS = row[2][0];
ret->aHitT = row[3][0];
ret->bName = cloneString(row[4]);
ret->bSize = sqlSigned(row[5]);
ret->bHitS = row[6][0];
ret->bHitT = row[7][0];
ret->overlap = sqlSigned(row[8]);
ret->reserved = sqlSigned(row[9]);
return ret;
}

void ocpFree(struct ocp **pEl)
/* Free a single dynamically allocated ocp such as created
 * with ocpLoad(). */
{
struct ocp *el;

if ((el = *pEl) == NULL) return;
freeMem(el->aName);
freeMem(el->bName);
freez(pEl);
}

void ocpFreeList(struct ocp **pList)
/* Free a list of dynamically allocated ocp's */
{
struct ocp *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    ocpFree(&el);
    }
*pList = NULL;
}

void ocpOutput(struct ocp *el, FILE *f, char sep, char lastSep) 
/* Print out ocp.  Separate fields with sep. Follow last field with lastSep. */
{
int i;
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->aName, sep);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->aSize, sep);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->aHitS, sep);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->aHitT, sep);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->bName, sep);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->bSize, sep);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->bHitS, sep);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->bHitT, sep);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->overlap, sep);
fputc(sep,f);
fprintf(f, "%d", el->reserved, lastSep);
fputc(lastSep,f);
}

struct ocp *ocpLoadFile(char *fileName)
/* Load all ocp's from file. */
{
struct lineFile *lf = lineFileOpen(fileName, TRUE);
struct ocp *list = NULL, *el;
char *row[10];

while (lineFileRow(lf, row))
    {
    el = ocpLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}
