/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import groovy.lang.Closure;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleDependencyCapabilitiesHandler;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.dsl.ComponentMetadataHandler;
import org.gradle.api.artifacts.dsl.ComponentModuleMetadataHandler;
import org.gradle.api.artifacts.dsl.DependencyConstraintHandler;
import org.gradle.api.artifacts.dsl.ExternalModuleDependencyVariantSpec;
import org.gradle.api.artifacts.query.ArtifactResolutionQuery;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.artifacts.type.ArtifactTypeContainer;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.dependencies.AbstractExternalModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultMinimalDependencyVariant;
import org.gradle.api.internal.artifacts.dsl.DependencyHandlerInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.DynamicAddDependencyMethods;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.query.ArtifactResolutionQueryFactory;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ProjectTestFixtures;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.metaobject.MethodAccess;
import org.gradle.internal.metaobject.MethodMixIn;
import org.gradle.util.internal.ConfigureUtil;

public abstract class DefaultDependencyHandler
implements DependencyHandlerInternal,
MethodMixIn {
    private final ConfigurationContainer configurationContainer;
    private final DependencyFactoryInternal dependencyFactory;
    private final ProjectFinder projectFinder;
    private final DependencyConstraintHandler dependencyConstraintHandler;
    private final ComponentMetadataHandler componentMetadataHandler;
    private final ComponentModuleMetadataHandler componentModuleMetadataHandler;
    private final ArtifactResolutionQueryFactory resolutionQueryFactory;
    private final AttributesSchema attributesSchema;
    private final VariantTransformRegistry transforms;
    private final ArtifactTypeRegistry artifactTypeContainer;
    private final ObjectFactory objects;
    private final PlatformSupport platformSupport;
    private final DynamicAddDependencyMethods dynamicMethods;

    public DefaultDependencyHandler(ConfigurationContainer configurationContainer, DependencyFactoryInternal dependencyFactory, ProjectFinder projectFinder, DependencyConstraintHandler dependencyConstraintHandler, ComponentMetadataHandler componentMetadataHandler, ComponentModuleMetadataHandler componentModuleMetadataHandler, ArtifactResolutionQueryFactory resolutionQueryFactory, AttributesSchema attributesSchema, VariantTransformRegistry transforms, ArtifactTypeRegistry artifactTypeContainer, ObjectFactory objects, PlatformSupport platformSupport) {
        this.configurationContainer = configurationContainer;
        this.dependencyFactory = dependencyFactory;
        this.projectFinder = projectFinder;
        this.dependencyConstraintHandler = dependencyConstraintHandler;
        this.componentMetadataHandler = componentMetadataHandler;
        this.componentModuleMetadataHandler = componentModuleMetadataHandler;
        this.resolutionQueryFactory = resolutionQueryFactory;
        this.attributesSchema = attributesSchema;
        this.transforms = transforms;
        this.artifactTypeContainer = artifactTypeContainer;
        this.objects = objects;
        this.platformSupport = platformSupport;
        this.configureSchema();
        this.dynamicMethods = new DynamicAddDependencyMethods(configurationContainer, new DirectDependencyAdder());
    }

    public Dependency add(String configurationName, Object dependencyNotation) {
        return this.add(configurationName, dependencyNotation, null);
    }

    public Dependency add(String configurationName, Object dependencyNotation, @Nullable Closure configureClosure) {
        return this.doAdd(this.configurationContainer.getByName(configurationName), dependencyNotation, configureClosure);
    }

    public <T, U extends ExternalModuleDependency> void addProvider(String configurationName, Provider<T> dependencyNotation, Action<? super U> configuration) {
        this.doAddProvider(this.configurationContainer.getByName(configurationName), dependencyNotation, this.closureOf(configuration));
    }

    public <T> void addProvider(String configurationName, Provider<T> dependencyNotation) {
        this.addProvider(configurationName, dependencyNotation, Actions.doNothing());
    }

    public <T, U extends ExternalModuleDependency> void addProviderConvertible(String configurationName, ProviderConvertible<T> dependencyNotation, Action<? super U> configuration) {
        this.addProvider(configurationName, dependencyNotation.asProvider(), configuration);
    }

    public <T> void addProviderConvertible(String configurationName, ProviderConvertible<T> dependencyNotation) {
        this.addProviderConvertible(configurationName, dependencyNotation, Actions.doNothing());
    }

    private <U extends ExternalModuleDependency> Closure<Object> closureOf(final Action<? super U> configuration) {
        return new Closure<Object>((Object)this, (Object)this){

            public Object call() {
                configuration.execute(Cast.uncheckedCast((Object)this.getDelegate()));
                return null;
            }

            public Object call(Object arguments) {
                configuration.execute(Cast.uncheckedCast((Object)arguments));
                return null;
            }
        };
    }

    public Dependency create(Object dependencyNotation) {
        return this.create(dependencyNotation, null);
    }

    public Dependency create(Object dependencyNotation, @Nullable Closure configureClosure) {
        Dependency dependency = this.dependencyFactory.createDependency(dependencyNotation);
        return (Dependency)ConfigureUtil.configure((Closure)configureClosure, (Object)dependency);
    }

    @Nullable
    private Dependency doAdd(Configuration configuration, Object dependencyNotation, @Nullable Closure configureClosure) {
        if (dependencyNotation instanceof Configuration) {
            throw new GradleException("Adding a Configuration as a dependency is no longer allowed as of Gradle 8.0.");
        }
        if (dependencyNotation instanceof ProviderConvertible) {
            return this.doAdd(configuration, ((ProviderConvertible)dependencyNotation).asProvider(), configureClosure);
        }
        if (dependencyNotation instanceof ProviderInternal) {
            ProviderInternal provider = (ProviderInternal)dependencyNotation;
            if (provider.getType() != null && ExternalModuleDependencyBundle.class.isAssignableFrom(provider.getType())) {
                ExternalModuleDependencyBundle bundle = (ExternalModuleDependencyBundle)Cast.uncheckedCast((Object)provider.get());
                for (MinimalExternalModuleDependency dependency : bundle) {
                    this.doAddRegularDependency(configuration, dependency, configureClosure);
                }
                return null;
            }
            return this.doAddProvider(configuration, (Provider<?>)provider, (Closure<?>)configureClosure);
        }
        if (dependencyNotation instanceof Provider) {
            return this.doAddProvider(configuration, (Provider)dependencyNotation, configureClosure);
        }
        return this.doAddRegularDependency(configuration, dependencyNotation, configureClosure);
    }

    private Dependency doAddRegularDependency(Configuration configuration, Object dependencyNotation, Closure<?> configureClosure) {
        Dependency dependency = this.create(dependencyNotation, configureClosure);
        configuration.getDependencies().add((Object)dependency);
        return dependency;
    }

    @Nullable
    private Dependency doAddProvider(Configuration configuration, Provider<?> dependencyNotation, Closure<?> configureClosure) {
        ProviderInternal provider;
        if (dependencyNotation instanceof ProviderInternal && (provider = (ProviderInternal)dependencyNotation).getType() != null && ExternalModuleDependencyBundle.class.isAssignableFrom(provider.getType())) {
            ExternalModuleDependencyBundle bundle = (ExternalModuleDependencyBundle)Cast.uncheckedCast((Object)provider.get());
            for (MinimalExternalModuleDependency dependency : bundle) {
                this.doAddRegularDependency(configuration, dependency, configureClosure);
            }
            return null;
        }
        Provider lazyDependency = dependencyNotation.map(this.mapDependencyProvider(configuration, configureClosure));
        configuration.getDependencies().addLater(lazyDependency);
        return null;
    }

    private <T> Transformer<Dependency, T> mapDependencyProvider(Configuration configuration, Closure<?> configureClosure) {
        return lazyNotation -> {
            if (lazyNotation instanceof Configuration) {
                throw new InvalidUserDataException("Adding a configuration as a dependency using a provider isn't supported. You should call " + configuration.getName() + ".extendsFrom(" + ((Configuration)lazyNotation).getName() + ") instead");
            }
            return this.create(lazyNotation, configureClosure);
        };
    }

    @Deprecated
    public Dependency module(Object notation) {
        return this.module(notation, null);
    }

    public Dependency project(Map<String, ?> notation) {
        return this.dependencyFactory.createProjectDependencyFromMap(this.projectFinder, notation);
    }

    @Deprecated
    public Dependency module(Object notation, @Nullable Closure configureClosure) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)"Declaring client module dependencies").replaceWith((Object)"component metadata rules")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "declaring_client_module_dependencies")).nagUser();
        return this.dependencyFactory.createModule(notation, configureClosure);
    }

    public Dependency gradleApi() {
        return this.dependencyFactory.createDependency((Object)DependencyFactoryInternal.ClassPathNotation.GRADLE_API);
    }

    public Dependency gradleTestKit() {
        return this.dependencyFactory.createDependency((Object)DependencyFactoryInternal.ClassPathNotation.GRADLE_TEST_KIT);
    }

    public Dependency localGroovy() {
        return this.dependencyFactory.createDependency((Object)DependencyFactoryInternal.ClassPathNotation.LOCAL_GROOVY);
    }

    public MethodAccess getAdditionalMethods() {
        return this.dynamicMethods;
    }

    public void constraints(Action<? super DependencyConstraintHandler> configureAction) {
        configureAction.execute((Object)this.dependencyConstraintHandler);
    }

    public DependencyConstraintHandler getConstraints() {
        return this.dependencyConstraintHandler;
    }

    public void components(Action<? super ComponentMetadataHandler> configureAction) {
        configureAction.execute((Object)this.getComponents());
    }

    public ComponentMetadataHandler getComponents() {
        return this.componentMetadataHandler;
    }

    public void modules(Action<? super ComponentModuleMetadataHandler> configureAction) {
        configureAction.execute((Object)this.getModules());
    }

    public ComponentModuleMetadataHandler getModules() {
        return this.componentModuleMetadataHandler;
    }

    public ArtifactResolutionQuery createArtifactResolutionQuery() {
        return this.resolutionQueryFactory.createArtifactResolutionQuery();
    }

    public AttributesSchema attributesSchema(Action<? super AttributesSchema> configureAction) {
        configureAction.execute((Object)this.attributesSchema);
        return this.attributesSchema;
    }

    public AttributesSchema getAttributesSchema() {
        return this.attributesSchema;
    }

    private void configureSchema() {
        this.attributesSchema.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE);
    }

    public ArtifactTypeContainer getArtifactTypes() {
        return (ArtifactTypeContainer)this.artifactTypeContainer.create();
    }

    public void artifactTypes(Action<? super ArtifactTypeContainer> configureAction) {
        configureAction.execute((Object)this.getArtifactTypes());
    }

    public AttributeContainer getDefaultArtifactAttributes() {
        return this.artifactTypeContainer.getDefaultArtifactAttributes();
    }

    public <T extends TransformParameters> void registerTransform(Class<? extends TransformAction<T>> actionType, Action<? super TransformSpec<T>> registrationAction) {
        this.transforms.registerTransform(actionType, registrationAction);
    }

    public Dependency platform(Object notation) {
        Dependency dependency = this.create(notation);
        if (dependency instanceof ModuleDependency) {
            ModuleDependency moduleDependency = (ModuleDependency)dependency;
            moduleDependency.endorseStrictVersions();
            this.platformSupport.addPlatformAttribute(moduleDependency, this.toCategory("platform"));
        } else if (dependency instanceof HasConfigurableAttributes) {
            this.platformSupport.addPlatformAttribute((HasConfigurableAttributes)dependency, this.toCategory("platform"));
        }
        return dependency;
    }

    public Dependency platform(Object notation, Action<? super Dependency> configureAction) {
        Dependency dep = this.platform(notation);
        configureAction.execute((Object)dep);
        return dep;
    }

    public Dependency enforcedPlatform(Object notation) {
        Dependency platformDependency = this.create(notation);
        if (platformDependency instanceof ExternalModuleDependency) {
            AbstractExternalModuleDependency externalModuleDependency = (AbstractExternalModuleDependency)platformDependency;
            MutableVersionConstraint constraint = (MutableVersionConstraint)externalModuleDependency.getVersionConstraint();
            constraint.strictly(externalModuleDependency.getVersion());
            this.platformSupport.addPlatformAttribute(externalModuleDependency, this.toCategory("enforced-platform"));
        } else if (platformDependency instanceof HasConfigurableAttributes) {
            this.platformSupport.addPlatformAttribute((HasConfigurableAttributes)platformDependency, this.toCategory("enforced-platform"));
        }
        return platformDependency;
    }

    public Dependency enforcedPlatform(Object notation, Action<? super Dependency> configureAction) {
        Dependency dep = this.enforcedPlatform(notation);
        configureAction.execute((Object)dep);
        return dep;
    }

    public Dependency testFixtures(Object notation) {
        Dependency testFixturesDependency = this.create(notation);
        if (testFixturesDependency instanceof ProjectDependency) {
            ProjectDependency projectDependency = (ProjectDependency)testFixturesDependency;
            projectDependency.capabilities((Action)new ProjectTestFixtures(projectDependency.getDependencyProject()));
        } else if (testFixturesDependency instanceof ModuleDependency) {
            ModuleDependency moduleDependency = (ModuleDependency)testFixturesDependency;
            moduleDependency.capabilities(capabilities -> capabilities.requireCapability((Object)new DefaultImmutableCapability(moduleDependency.getGroup(), moduleDependency.getName() + "-test-fixtures", null)));
        }
        return testFixturesDependency;
    }

    public Dependency testFixtures(Object notation, Action<? super Dependency> configureAction) {
        Dependency testFixturesDependency = this.testFixtures(notation);
        configureAction.execute((Object)testFixturesDependency);
        return testFixturesDependency;
    }

    public Provider<MinimalExternalModuleDependency> variantOf(Provider<MinimalExternalModuleDependency> dependencyProvider, Action<? super ExternalModuleDependencyVariantSpec> variantSpec) {
        return dependencyProvider.map(dep -> {
            DefaultExternalModuleDependencyVariantSpec spec = (DefaultExternalModuleDependencyVariantSpec)this.objects.newInstance(DefaultExternalModuleDependencyVariantSpec.class, new Object[]{this.objects, dep});
            variantSpec.execute((Object)spec);
            return new DefaultMinimalDependencyVariant((MinimalExternalModuleDependency)dep, (Action<? super AttributeContainer>)spec.attributesAction, (Action<? super ModuleDependencyCapabilitiesHandler>)spec.capabilitiesMutator, spec.classifier, spec.artifactType);
        });
    }

    public Provider<MinimalExternalModuleDependency> enforcedPlatform(Provider<MinimalExternalModuleDependency> dependencyProvider) {
        return this.variantOf(dependencyProvider, (Action<? super ExternalModuleDependencyVariantSpec>)((Action)spec -> {
            DefaultExternalModuleDependencyVariantSpec defaultSpec = (DefaultExternalModuleDependencyVariantSpec)spec;
            defaultSpec.attributesAction = attrs -> attrs.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.objects.named(Category.class, "enforced-platform")));
        }));
    }

    private Category toCategory(String category) {
        return (Category)this.objects.named(Category.class, category);
    }

    public static class DefaultExternalModuleDependencyVariantSpec
    implements ExternalModuleDependencyVariantSpec {
        private final ObjectFactory objects;
        private final MinimalExternalModuleDependency dep;
        private Action<? super AttributeContainer> attributesAction = null;
        private Action<ModuleDependencyCapabilitiesHandler> capabilitiesMutator = null;
        private String classifier;
        private String artifactType;

        @Inject
        public DefaultExternalModuleDependencyVariantSpec(ObjectFactory objects, MinimalExternalModuleDependency dep) {
            this.objects = objects;
            this.dep = dep;
        }

        public void platform() {
            this.attributesAction = attrs -> attrs.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.objects.named(Category.class, "platform")));
        }

        public void testFixtures() {
            this.capabilitiesMutator = capabilities -> capabilities.requireCapability((Object)new DefaultImmutableCapability(this.dep.getModule().getGroup(), this.dep.getModule().getName() + "-test-fixtures", null));
        }

        public void classifier(String classifier) {
            this.classifier = classifier;
        }

        public void artifactType(String artifactType) {
            this.artifactType = artifactType;
        }
    }

    private class DirectDependencyAdder
    implements DynamicAddDependencyMethods.DependencyAdder<Dependency> {
        private DirectDependencyAdder() {
        }

        @Override
        public Dependency add(Configuration configuration, Object dependencyNotation, @Nullable Closure configureAction) {
            return DefaultDependencyHandler.this.doAdd(configuration, dependencyNotation, configureAction);
        }
    }
}

