/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import java.util.Collections;
import java.util.List;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.internal.DefaultProblemReporter;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.ProblemEmitter;
import org.gradle.api.problems.internal.ProblemTransformer;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scopes.BuildTree.class})
public class DefaultProblems
implements InternalProblems {
    private final ProblemEmitter emitter;
    private final List<ProblemTransformer> transformers;
    private final InternalProblemReporter internalReporter;

    public DefaultProblems(ProblemEmitter emitter) {
        this(emitter, Collections.emptyList());
    }

    public DefaultProblems(ProblemEmitter emitter, List<ProblemTransformer> transformers) {
        this.emitter = emitter;
        this.transformers = transformers;
        this.internalReporter = DefaultProblems.createReporter("org.gradle", emitter, transformers);
    }

    @Override
    public ProblemReporter forNamespace(String namespace) {
        if ("org.gradle".equals(namespace)) {
            throw new IllegalStateException("Cannot use org.gradle namespace.");
        }
        return DefaultProblems.createReporter(namespace, this.emitter, this.transformers);
    }

    private static DefaultProblemReporter createReporter(String namespace, ProblemEmitter emitter, List<ProblemTransformer> transformers) {
        return new DefaultProblemReporter(emitter, transformers, namespace);
    }

    @Override
    public InternalProblemReporter getInternalReporter() {
        return this.internalReporter;
    }
}

