/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import groovy.util.Node;
import java.util.LinkedHashMap;
import org.gradle.plugins.ide.idea.model.Dependency;

public class ModuleDependency
implements Dependency {
    private String name;
    private String scope;
    private boolean exported;

    public ModuleDependency(String name, String scope) {
        this.name = name;
        this.scope = scope;
        this.exported = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isExported() {
        return this.exported;
    }

    public void setExported(boolean exported) {
        this.exported = exported;
    }

    @Override
    public void addToNode(Node parentNode) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("type", "module");
        attributes.put("module-name", this.name);
        if (this.exported) {
            attributes.put("exported", "");
        }
        if (!Strings.isNullOrEmpty((String)this.scope) && !"COMPILE".equals(this.scope)) {
            attributes.put("scope", this.scope);
        }
        parentNode.appendNode((Object)"orderEntry", attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ModuleDependency that = (ModuleDependency)o;
        return Objects.equal((Object)this.name, (Object)that.name) && this.scopeEquals(this.scope, that.scope);
    }

    private boolean scopeEquals(String lhs, String rhs) {
        if ("COMPILE".equals(lhs)) {
            return Strings.isNullOrEmpty((String)rhs) || "COMPILE".equals(rhs);
        }
        if ("COMPILE".equals(rhs)) {
            return Strings.isNullOrEmpty((String)lhs) || "COMPILE".equals(lhs);
        }
        return Objects.equal((Object)lhs, (Object)rhs);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.getScopeHash();
        return result;
    }

    private int getScopeHash() {
        return !Strings.isNullOrEmpty((String)this.scope) && !this.scope.equals("COMPILE") ? this.scope.hashCode() : 0;
    }

    public String toString() {
        return "ModuleDependency{name='" + this.name + "', scope='" + this.scope + "'}";
    }
}

